"File ModalDialog.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

Gui subclass:  #ModalDialog
        instanceVariableNames: 'dialogShell messageDispatch'
        classVariableNames: ''
        poolDictionaries: ''
        category: 'Graphics-Windows'
!

!ModalDialog methodsFor: 'initialization'!

message: queryString in: parent
"Initialize dialog and button actions"
    messageDispatch := Dictionary new.
    dialogShell := BTransientWindow new: 'Modal dialog' in: (parent rootView blox).
    dialogShell width: 200.
    blox := (BDialog new: dialogShell label: queryString prompt: nil).
    dialogShell createToplevelWindow: 'Modal dialog'.
!

addButton: label message: block
    messageDispatch at: (messageDispatch size + 1) put: block.
    blox addButton: label receiver: self index: (messageDispatch size).
!

alertMessage: queryString in: parent
    self message: queryString in: parent.
    self addButton: 'Ok' message: [].
    self display: parent.
!!

!ModalDialog methodsFor: 'displaying'!

display: parent
    dialogShell map.
    blox center.
    blox loop.
!!

!ModalDialog methodsFor: 'private'!

dispatch: index
    (messageDispatch at: index) value.
!!
