"File Manager.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

View subclass:  #Manager
        instanceVariableNames: ''
        classVariableNames: ''
        poolDictionaries: ''
        category: 'Graphics-Windows'
!

!Manager methodsFor: 'childViews'!

addChildView: aChildView
    "Add childView to list of childViews of a view"
    childViews isNil
	"Initialize childViews collection"
	ifTrue: [ childViews := OrderedCollection new ].
    childViews add: aChildView.
    "Set parentView of aChildView to self"
    aChildView parentView: self.
!

deleteChildView: aChildView
    childViews notNil 
	ifTrue: [ childViews remove: aChildView. 
		  aChildView remove].
!!
