"File CtxtInspect.st
======================================================================
|
| Copyright 1990, 91, 92, 94, 95, 99 Free Software Foundation, Inc.
| Written by Brad Diller.
|
| This file is part of GNU Smalltalk.
|
| GNU Smalltalk is free software; you can redistribute it and/or modify it
| under the terms of the GNU General Public License as published by the Free
| Software Foundation; either version 2, or (at your option) any later version.
| 
| GNU Smalltalk is distributed in the hope that it will be useful, but WITHOUT
| ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
| FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
| details.
| 
| You should have received a copy of the GNU General Public License along with
| GNU Smalltalk; see the file COPYING.  If not, write to the Free Software
| Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================
"

GuiData subclass: #ContextInspector
     instanceVariableNames: 'contextHolder theClass theSelector'
     classVariableNames: ''
     poolDictionaries: ''
     category: 'Graphics-Browser'
! 

!ContextInspector class methodsFor: 'instance creation'!

new: contextBrowser
    ^self new init: contextBrowser
! !

!ContextInspector methodsFor: 'private'!


init: contextBrowser
    | topView toplevel container text lowerpane pane list context llpane lrpane textView|
    contextHolder := contextBrowser.
    context := contextHolder currentContext.

    theSelector := context home selector.
    theSelector isNil ifTrue: ['Unable to inspect method context' printNl. ^self].

    topView := ((BrowserShell new: 'Context Inspector' ) data: self).
    toplevel := topView blox.
    toplevel width: 500 height: 350.

		self setBackgroundColorOn: topView blox.

    pane := Form new: 'panes' in: topView.
    topView addChildView: pane.
    
		self setBackgroundColorOn: pane blox.
    pane addChildView: ((textView := PText new: pane)
    data: self;
    stateChange: #text;
    handleUserChange: #compile:from:;
    textMsg: #text;
    yourself).
    textView menuInit: ((PopupMenu new: textView label: '') selectors: 
   #(('Cut' gstCut) ('Copy' gstCopy) ('Paste' gstPaste) 
    () ('Clear' gstClear) () ('Line...' line)  ('Find...' find) ()
    ('Do it' eval) ('Print it' evalAndPrintResult) ('Inspect' evalAndInspectResult) 
    () ('Accept' compileIt)
    ('Cancel' revert) () ('Close' close))
                receiver: textView
                argument: nil).
    text := textView blox.
    text width: 500; height: 175.
    
    theClass := context methodClass.

    text contents: (theClass sourceCodeAt: theSelector).

    lowerpane := Form new: 'panes' in: pane.
    pane addChildView: lowerpane.
    self setBackgroundColorOn: pane blox.
    lowerpane blox posVert: (textView blox).
    lowerpane blox height: 175.
    
    llpane := Form new: 'panes' in: lowerpane.
    llpane blox width: 250 height: 175.
    lowerpane addChildView: llpane.
    self setBackgroundColorOn: llpane blox.

    contextHolder currentContext receiver inspect: llpane.

    lrpane := Form new: 'panes' in: lowerpane.
    lowerpane addChildView: lrpane.
    lrpane blox width: 250 height: 175.
    lrpane blox posHoriz: llpane blox.
    self setBackgroundColorOn: lrpane blox.

    StackInspector new openOn: (contextHolder currentContext) in: lrpane.
    lrpane blox posHoriz: (llpane blox).

    toplevel map.
!!

!ContextInspector methodsFor: 'text pane'!

text
"Return source code for the selected method"
    theSelector notNil 
        ifTrue: [^theClass sourceCodeAt: theSelector].
    ^''.
!

compile: aString from: aView
"Compile aString derived from text in text view for the selected selector"
    theSelector notNil  
        ifTrue: [ theClass compile: aString classified: 
                      ((theClass compiledMethodAt: theSelector) methodCategory) 
                           ifError: [:fname :lineNo :errorString |
                                                                  aView displayError: errorString at: lineNo.
                                                                  ^nil]]
!!

!ContextInspector methodsFor: 'private'!

setBackgroundColorOn: win
    win backgroundColor: 'LemonChiffon'.
! !

! Object methodsFor: 'debugging' !

inspect: pane
"Open an Inspector window on self"
    Inspector new openOn: self in: pane
!!

! Dictionary methodsFor: 'debugging' !

inspect: pane
"Open a DictionaryInspector window on self"
    DictionaryInspector new openOn: self in: pane
!!


! BlockContext methodsFor: 'debugging' !

inspect: pane
"Open an Inspector window on self"
    ContextInspector new openOn: self in: pane
!!

! MethodContext methodsFor: 'debugging' !

inspect: pane
"Open a DictionaryInspector window on self"
    ContextInspector new openOn: self in: pane
!!

