/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU PIPS; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

/*
 * Name          : pips/src/pipsJobAvailable.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 * pipsJobAvailable (int jobId[], int *job, int ntask, int newJobs)
 *   int jobId[]      IS   Array of currently processed jobs (on all hosts)
 *   int *job         IS   Returned number of next job to process 
 *   int ntask        IS   Number of tasks available for parallel
 *                         data processing (spawned by pipsTaskManager)
 *   int task         IS   Index of task that has most recently submitted a
 *                         finished job and gets another one now
 *   int newJobs      IS   Indicates wheter or not new jobs are available
 *                         or if the competition has allready started.
 *
 * Description   : 
 *
 *   pipsJobAvailable returns the number of a new job. If all new jobs are
 *   distributed, then a job currently processed is returned, so a competition
 *   among the tasks will be started.
 */

#include "pips.h"   /* PIPS system header file  */
#include "pvm3.h"   /* PVM system header file   */

#ifdef __STDC__

int pipsJobAvailable (int jobId[], int *job, int ntask,
                       int task, int newJobs)

#else

pipsJobAvailable (jobId, job, ntask, task, newJobs)
    int jobId[];
    int *job;
    int ntask;
    int newJobs;

#endif
{
  long i;        /* Index to jobId[]            */

/*
 * Select a new job. If there are no more new jobs, then select a processed
 * job (start a competition)
 * NOTE: Rotating through the jobs, starting with the right neighbor of last
 *       finished job distributes the jobs about equally among the tasks
 */
  if (! newJobs) {
    i = task;
    do
      i = (i+1) % ntask;             /* increase i; set to 0, if ntask-1 */
    while ((jobId [i] == PipsNoJob) && (i != task));
    (*job) = jobId [i];
  } /* end if job */

/*
 * Return true, while there is still an unfinished job left
 */
  if (*job != PipsNoJob) {

/*
 * Remember that task tid [task] is doing '*job' from now on
 */
    jobId [task] = *job;
    pvm_initsend (PvmDataDefault);
    return (1);
  } /* end if */
  return (0);
} /* pipsJobAvailable */


/* end pipsJobAvailable.c */
