/*
* (C) 2000, 2001 David O'Toole dto@gnu.org $Date: 2001/04/08 00:38:25 $
* $Revision: 1.6 $
* 
* OX_WRAPPERS.H
*
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
* 
*/

#ifndef _ox_wrappers_h_
#define _ox_wrappers_h_ 

extern "C" {
#include "octal.h"
#include "machine.h"
}

// class OX_Machine just defines the interface to keep things
// consistent.  none of its member functions will ever be called,
// because calls to the derived class will all be statically bound 

class OX_Machine {
	public: 
  	OX_Machine(machine* m) {};        
	~OX_Machine() {};

	static int initialize(machine_type* t) { return -1; };   
	static void describe(char* dest, int which, param value) {}; 

	void event(int channel, int which, param value) {};           
	int work(int block_size) { return -1; }; 
 	int channel(int creating, int channel_number) { return -1; };
	
	// you typically won't need to access this next field from C++
	machine* m; 

	// package functions and i/o buffers
	package* core; 
	samp *lin, *rin, *lout, *rout; 
};

#endif 
