/*
* Copyright 2000 David O'Toole $Date: 2001/03/11 02:08:03 $
* 
* GNU OCTAL output subsystem. Currently uses OSS. 
* http://www.gnu.org/software/octal/
*
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
*
*/

static const char rcsid[]="$Id: output.c,v 1.2 2001/03/11 02:08:03 dto Exp $";

#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdlib.h>

/* oss api header */
#include <sys/soundcard.h> 

#include "octal.h"
#include "output.h"

typedef signed short dev_sample; /* system-specific sample format */ 

/* important global data */ 
static int sound_fd=-1; 
static int block_size = 0; 
static dev_sample *buffer = 0; 
static int buffer_size_bytes;

/* this doesn't set the OSS fragment size, just the internal buffer size */
/* for converting to the soundcard's expected sample format.             */

void set_block_size(int bs) {
  
  block_size = bs;
  if (buffer) free(buffer);
  buffer_size_bytes = block_size * sizeof(dev_sample) * 2;
  buffer = (dev_sample*)malloc(buffer_size_bytes);
  
}

void close_sound() {
  sound_fd   = -1;
  block_size = 0;
  free(buffer);
  buffer = 0;
}



int init_sound(int samplerate) {
  
  int oss_format = AFMT_S16_LE; /* signed, 16-bit, little-endian audio */
  int oss_speed = samplerate;
  int oss_stereo = 1;
  int tolerance = samplerate/50+1;  /* this is for weird soundcards (like mine :-) */

  if (block_size == 0) return -1;

  sound_fd = open("/dev/dsp", O_WRONLY); 

  if ( sound_fd != -1 ) {
    	
    printf("Opened /dev/dsp with value of %d\n", sound_fd);		
		
    /* attempt to set up hardware to accept our format */
    ioctl(sound_fd, SNDCTL_DSP_RESET, 0);
    ioctl(sound_fd, SNDCTL_DSP_STEREO, &oss_stereo);
    if ( (ioctl(sound_fd, SNDCTL_DSP_SETFMT, &oss_format) != -1) && (oss_format==AFMT_S16_LE) &&
	 (ioctl(sound_fd, SNDCTL_DSP_SPEED, &oss_speed) != -1) && 
	 (abs(oss_speed-samplerate) <= tolerance) )
      { return oss_speed; }

    /* note on the above: some cards return wrong values for the sampling rate. they're often 
       slightly off what they should be doing, i.e. 44099 instead of 44100. Someone told me that
       they may actually be using that sample rate, meaning that everything will be detuned. 
       if this is so, the freq-table should be rebuilt with the new sampling rate.
    */
		
    fprintf(stderr, "output: /dev/dsp won't accept requested sample rate\n");  	
    return -1;
  }
	
  fprintf(stderr, "output: /dev/dsp inaccessible\n");
  return -1;
}




/* output_block() takes a left and a right channel; if you want to output mono,
   pass the same buffer to both inputs 
   currently uses blocking i/o. this will probably change. 
*/ 

void output_block(samp *left, samp *right, int num) {
  	int i;
	int opos = 0;

  	if (!buffer) 
		ox_die("%%%%OCTAL: No output buffer in sound driver.\n");
   
	if (sound_fd == -1) 
		ox_die("%%%%OCTAL: No sound device open.\n ");
  	  
	// now convert from OCTAL's sample format to the soundcard's. 

	for (i=0; i<num; i++) {		
    	buffer[opos]   = (dev_sample)(32767.0f * left[i]);   /* thanks andy */ 
    	buffer[opos+1] = (dev_sample)(32767.0f * right[i]);
		opos += 2;
	}
	write(sound_fd, buffer, num * sizeof(dev_sample) * 2);
}




