/*

NOISE.C
A quickie noise generator

*/
 
#include "machine.h"  // OCTAL machine interface 

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

enum { ix_trigger, ix_vol, ix_color };  
enum { my_track = 0 };
enum { my_num_params = 3 };

char *color_options[] = {"white", "pink", "brown"};

char *my_params[] = {
	"trigger|press me|trigger|button|0|1|0",
	"vol|volume|generic|slider|0|255|30",	
	"color|noise color|generic|option|0|2|0",
	NULL
};


typedef struct _my_state { 
	param vol;        // max volume of sample
	int play;		  // make a sound on next block?
} my_state; 

 
int ox_init(machine_type* t)
{
  
	t->long_name        = "Useless White Noise Box"; 
	t->short_name       = "noise"; 
	t->max_channels     = 1; 
	t->input_channels   = 0; 

	t->output_channels  = 1;   
	t->param_info		= my_params;

	return(1); 
}


void ox_create(machine* m) 
{
	my_state* s;

	s = m->pkg->alloc(sizeof(my_state));

	s->vol  = 0x80;     
	s->play = 0;

	m->state = s;  
}



void ox_destroy(machine* m) 
{
	m->pkg->free(m->state);  
}


void ox_event(machine* m, int track, int param_index, param value) 
{
  my_state *s = m->state; 
     
  switch(param_index) {
	case ix_trigger:
		s->play = 1;
		break;  

	case ix_vol:
		s->vol = value;
		break;
	default:
	
  }
} 


void ox_desc(char* dest, int which_param, param value) 
{
  	float x;
  	int percent; 

	switch (which_param) {
  
	case ix_trigger: 
		sprintf(dest, "Boing!.");
		break; 

  	case ix_vol: 
 		x = ((float)value) / 255.0;  /* scale from 0x00..0xFE to floating point 0..1 */ 
		percent = (int)(x * 100);
		sprintf(dest, "%d%%", percent); 
		break;

	case ix_color:
		if (value > 2) sprintf(dest, "OUT OF RANGE");
		else sprintf(dest, color_options[(int)value]);	
		
		break;

	default: 
 		sprintf(dest, "ERROR"); 
	}
}


int ox_work(machine* m, int block_size) 
{

 	my_state* s;  
 	samp* out;              /* mono output for this machine */ 
 	samp p, temp; 
 	int i;

 	s = m->state;         /* grab our state data address                           */ 
 	out = m->lout;        /* since lout=rout for mono machines, I could use either */ 

 	if (s->play == 0) return (0); /* nothing to generate */  
	s->play = 0;

 	for (i=0; i < block_size; i++) {
		temp = s->vol*rand();
		p = (float)temp / 255.0;
		out[i] = p; 

 	}

 	return(1);          /* generated successfully */ 
}

void ox_channel(machine* m, int creating, int channel) 
{ 

}



