/*
 * CONTROL_BOX.H
 * Header for machine's parameter control boxes
 * machine view recieves any messages from core and distributes them to
 *   the boxes.  
 */
#ifndef _control_box_h_
#define _control_box_h_

#include <gtk/gtk.h>
#include "engine.h"

//
// CONTROL BOX FOR ONE MACHINE'S PARAMS
// Presumed to be docked in a box somewhere, but potentially removable. 

typedef struct _control_box {

	GtkWidget *dock;				// toplevel widget that we control						
	
	engine *subject;
	
	int machine_id;				    // the # of the machine that this box controls
	int track;						// track # being controlled/observed	

	// param and track are stored with the GtkAdjustments
} control_box; 


// 
// CREATION AND DESTRUCTION
//

void cb_create(control_box **target, engine *model_cache, int machine_id, GtkWidget *parent_container);
void cb_destroy(control_box **target);

//
// GTK+ CALLBACKS FOR CONTROL_BOX
//

gboolean cb_delete_event_cb(GtkWidget *widget, gpointer data);
void cb_update_cb(GtkAdjustment *adj, gpointer unused); 
void cb_update_adjustment_cb (GtkObject *object, gpointer data);

//
// PRIVATE UTILITIES
//

void build_widget(control_box *self, int machine_id, machine_type *mt, int i, GtkWidget *table);







#endif
