/*
* $Header: /cvsroot/octal/octal/ox_wrappers.cc,v 1.4 2001/04/08 00:11:17 dto Exp $
* (C) 2000 David O'Toole dto@gnu.org $Date: 2001/04/08 00:11:17 $
* $Revision: 1.4 $
* 
* OX_WRAPPERS.CC
* 
* Implementations for the wrapper functions. 
*
*
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
* 
*/

#ifndef OX_CLASS
#error you must #define the macro OX_CLASS before using ox_wrappers
#endif

extern "C" {      // give these functions C linkage so OCTAL can find them 

inline void update_signals(machine* m, OX_CLASS* x) 
{
	x->lin = m->lin;
	x->rin = m->rin;
	x->lout = m->lout;
	x->rout = m->rout;
}

inline OX_CLASS* grab_object(machine* m) 
{
	return ((OX_CLASS*)(m->state));
}

/* the wrapper functions themselves. primarily these hide the "state objects" */ 

OX_CLASS* temp;

int ox_init(machine_type* t) 
{
	return OX_CLASS::initialize(t);
}

void ox_create(machine* m) 
{
	temp = new OX_CLASS(m);    // call the derived class's constructor                   
	m->state = (void*)temp;    // store the location in m->state                           
	temp->m = m;               // make sure derived class can get to the machine struct  
	temp->core = m->pkg;       // make sure the package is there too                     
}

void ox_destroy(machine* m) 
{
	temp = grab_object(m); 
	delete temp; 
}

int ox_work(machine* m, int block_size) 
{
	temp = grab_object(m);
	update_signals(m, temp); 
	return temp->work(block_size);
}

void ox_event(machine* m, int track, int which, param value) 
{
	temp = grab_object(m);
	temp->event(track, which, value); 
}

int ox_channel(machine* m, int creating, int channel_number) 
{
	temp = grab_object(m);
	return temp->channel(creating, channel_number);
}

void ox_desc(char* dest, int which, param value) {
  return OX_CLASS::describe(dest, which, value);
}


} /* end extern C */ 
