/*
* (C) 2000 David O'Toole $Date: 2001/04/07 23:27:07 $
* $Revision: 1.6 $
* 
* DELAY.C
* A (very) simple delay effect for OCTAL. 
* Currently only in mono.  
*
* This software is distributed under the terms of the
* GNU General Public License (GPL). Read the included file
* COPYING for more information. 
* 
*/

static const char rcsid[]="$Id: delay.c,v 1.6 2001/04/07 23:27:07 dto Exp $";

#include "machine.h" /* machine interface            */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

enum {ix_length, ix_feedback};  /* indexes of parameters in an event */
enum {my_track = 1 };           /* always 1 with effects             */

char *my_params[] = {
	"|len|delay length|generic|slider|1|8|3|",
	"|fb|feedback|generic|slider|0|1.0|0.1|",
	NULL
};


/* note: parameter 0 is currently ignored... will be fixed later */

typedef struct _my_state { 
  samp* blockbuf;
  float feedback_factor;
} my_state; 

 
int ox_init(machine_type* t) {
  
  t->long_name        = "Simple Mono Delay Machine"; 
  t->short_name       = "mdelay"; 
  t->max_channels     = 1; 
  t->input_channels   = 1; 
  t->output_channels  = 1;   
  t->param_info	= my_params;

  return(1); 
}

 
void ox_create(machine* m) 
{
	my_state* s;
	int i; 

	s = (my_state*) malloc(sizeof(my_state));

	s->feedback_factor = 0.1;     
	s->blockbuf = m->pkg->alloc(OX_SAMPLING_RATE * sizeof(samp));

	for (i = 0; i < OX_SAMPLING_RATE; i++)
		s->blockbuf[i] = 0.0;	

	m->state = (void*)s;  
}


void ox_destroy(machine* m) 
{
  m->pkg->free( ((my_state*)(m->state)) -> blockbuf);
  m->pkg->free(m->state);
  m->state = 0;
}


void ox_event(machine* m, int track, int param_index, param value) 
{  
	my_state *s = (my_state*)m->state; 

	printf ("DELAY EVENT :: %d %f\n", param_index, value);	
  
	switch (param_index) {
	case ix_length: 
		break; // not yet implemented 
	case ix_feedback:
		s->feedback_factor =  value;   
		break; 
  }
} 


/* write to desc a string describing a given parameter value... this
   is used for interactive tweaking of parameters, giving the user
   feedback on what's happening when he/she pulls a slider...  
 */

void ox_desc(char* dest, int which_param, param value) {
  int percent; 

  switch (which_param) {
  
  case ix_length: 
    sprintf(dest, "N/A");  
    break; 

  case ix_feedback: 
    percent = (int)(value * 100.0);
    sprintf(dest, "%d%%", percent); 
    break;

  default: 
    sprintf(dest, "ERROR"); 
  };
}


// ox_work should actually do the job of doing output. return 1 if you generated 
// something, 0 if not
//

int ox_work(machine* m, int block_size) {

 my_state* s;  
 samp* mout;              /* mono out */ 
 samp* min;               /* mono in  */ 
 int i;

 s = (my_state*)m->state;       /* grab our state data address */ 
 mout = m->lout;                   
 min = m->lin; 

 /* 1. first apply the feedback decay to the existing buffer */
 /* 2. then add the current input signal to that buffer      */ 
 /* 3. output the buffer */ 

 for (i=0; i < block_size; i++) {
   s->blockbuf[i] *= s->feedback_factor;
   s->blockbuf[i] += min[i];
   mout[i] = s->blockbuf[i];
 }

 return (1);
}

void ox_channel(machine* m, int creating, int channel) { 

}


