# title	   generic variables
# file	   make/Variables.make
#
# do not change this file for site-wide extensions; please use 
# make/$(outdir)/Site.make; 
#
# Any change in files in this directory (make/) would be distributed, if 
# you do make dist 

# directory names:

# depth from group-dir
# not eh, normally used
DEPTH = $(depth)/$(package-depth)

topdir := $(shell cd $(depth); pwd)
pwd := $(shell pwd)

# huh?
buildprefix=$(depth)

ifdef CONFIGSUFFIX
outdir=out-$(CONFIGSUFFIX)
else
outdir=out
endif

# derived names
ifeq ($(distdir),)
  distdir = $(depth)/$(outdir)/$(DIST_NAME)
  DIST_NAME = $(package)-$(TOPLEVEL_VERSION)
endif
distname = $(package)-$(TOPLEVEL_VERSION)

depdir = $(outdir)

makeout = $(buildprefix)/make/$(outdir)
docout = $(buildprefix)/Documentation/$(outdir)
binout = $(buildprefix)/bin/$(outdir)

doc-dir = $(depth)/Documentation
make-dir = $(depth)/make
po-dir = $(depth)/po

# user settings:
#
include $(make-dir)/Variables.make
include $(make-dir)/User.make
#

# urg
# sort-out which of these are still needed
#
$(package)_bindir = $(depth)/bin
step-bindir = $(depth)/$(stepmake)/bin
abs-step-bindir = $(topdir)/$(stepmake)/bin
#
group-dir = $(shell cd $(DEPTH)/..; pwd)
release-dir = $(group-dir)/releases
patch-dir = $(group-dir)/patches
#
# i have in $HOME/.rpmrc
#     topdir: /home/fred/usr/src/Redhat
#
rpm-sources = $(release-dir)
rpm-build = $(group-dir)/RedHat/BUILD
#

# hmm
configheader=$(outdir)/config.hh

# need to be defined in local Makefiles:
#
FOOBAR = 
# the version:
#
ifneq ($(MY_PATCH_LEVEL),$(FOOBAR))
VERSION=$(MAJOR_VERSION).$(MINOR_VERSION).$(PATCH_LEVEL).$(MY_PATCH_LEVEL)
else
VERSION=$(MAJOR_VERSION).$(MINOR_VERSION).$(PATCH_LEVEL)
endif

ifneq ($(TOPLEVEL_MY_PATCH_LEVEL),$(FOOBAR))
TOPLEVEL_VERSION=$(TOPLEVEL_MAJOR_VERSION).$(TOPLEVEL_MINOR_VERSION).$(TOPLEVEL_PATCH_LEVEL).$(TOPLEVEL_MY_PATCH_LEVEL)
else
TOPLEVEL_VERSION=$(TOPLEVEL_MAJOR_VERSION).$(TOPLEVEL_MINOR_VERSION).$(TOPLEVEL_PATCH_LEVEL)
endif
state-vector = $(make-dir)/STATE-VECTOR
#

# clean file lists:
#
ERROR_LOG = 2> /dev/null
SILENT_LOG = 2>&1 >  /dev/null
date := $(shell date +%x)	#duplicated?

# compile and link options:
#
ARFLAGS = ru
CFLAGS = $(ICFLAGS) $(DEFINES) $(INCLUDES) $(USER_CFLAGS) $(EXTRA_CFLAGS) $(MODULE_CFLAGS)

# added two warnings that are treated by cygwin32's gcc 2.7.2 as errors.
# huh, but still, no warnings even provoced with linux's gcc 2.7.2.1?

# -pipe makes it go faster, but is not supported on all platforms. 
# EXTRA_CXXFLAGS= -Wall -Winline -W -Wmissing-prototypes -Wmissing-declarations -Wconversion
EXTRA_CXXFLAGS= -Wall -W -Wmissing-prototypes -Wmissing-declarations -Wconversion

CXXFLAGS = $(CFLAGS) $(USER_CXXFLAGS) $(EXTRA_CXXFLAGS) $(MODULE_CXXFLAGS)
INCLUDES =  -Iinclude -I$(outdir) $($(PACKAGE)_INCLUDES)
C_OUTPUT_OPTION = $< -o $@
CXX_OUTPUT_OPTION = $< -o $@
LDFLAGS = $(ILDFLAGS) $(USER_LDFLAGS) $(EXTRA_LDFLAGS) $(MODULE_LDFLAGS) $($(PACKAGE)_LDFLAGS)
LOADLIBES = $(MODULE_LIBES) $($(PACKAGE)_LIBES) $(EXTRA_LIBES)
# urg: for windows ?
# LOADLIBES = $(MODULE_LIBES) $($(PACKAGE)_LIBES) $(EXTRA_LIBES) -lstdc++
#

# macro compiler:
#
M4 = m4
# 

# librarian:
#
AR = ar
AR_COMMAND = $(AR) $(ARFLAGS) $@
#
RANLIB_COMMAND=$(RANLIB) $@
#

# compiler:
#
DO_C_COMPILE = $(DODEP) $(CC) -c $(CFLAGS) $(C_OUTPUT_OPTION) 
DO_CXX_COMPILE=$(DODEP) $(CXX) -c $(CXXFLAGS) $(CXX_OUTPUT_OPTION)
#

# linker:
#
#LD = $(CXX)
LD_COMMAND = $(LD) $(LDFLAGS) -o $@
#

# dependencies:
#
depfile = $(depdir)/$(subst .o,.dep,$(notdir $@))#
DODEP=rm -f $(depfile); DEPENDENCIES_OUTPUT="$(depfile) $(outdir)/$(notdir $@)"
#

# utils:
#
#FLEX = flex
#BISON = bison
#

# generic target names:
#
ifdef NAME
EXECUTABLE = $(outdir)/$(NAME)$(EXE)
else
EXECUTABLE =
endif

EXECUTABLES = $(notdir $(EXECUTABLE))
LIB_PREFIX = lib

ifndef LIB_SUFFIX
LIB_SUFFIX = .a
endif

LIBRARY = $(outdir)/$(LIB_PREFIX)$(NAME).a
SHAREDLIBRARY=$(outdir)/$(LIB_PREFIX)$(NAME).so
#

#replace to do stripping of certain objects
STRIPDEBUG=true 

DISTFILES=$(EXTRA_DISTFILES) Makefile $(ALL_SOURCES)
DOCDIR=$(depth)/$(outdir)

pod2groff=$(POD2MAN) --center="LilyPond documentation" --section="0"\
	--release="LilyPond $(TOPLEVEL_MAJOR_VERSION).$(TOPLEVEL_MINOR_VERSION).$(TOPLEVEL_PATCH_LEVEL)" $< > $@


STRIP=strip --strip-debug
ifdef stablecc
 STABLEOBS=$(addprefix $(outdir)/,$(stablecc:.cc=.o))
endif

# substitute $(STRIP) in Site.make if you want stripping
DO_STRIP=true


LOOP=$(foreach i,  $(SUBDIRS),  $(MAKE) -C $(i) $@ &&) true

