# -*-Makefile-*-
# title	   Toplevel.make

# override Variables.make:
# do not dist ./Makefile (is copied from make/Toplevel.make)
# 
DISTFILES := $(EXTRA_DISTFILES)
#

localdist: configure check-make-deps check-doc-deps $(README_FILES) $(README_TXTFILES)

local-distclean: 
	rm -f config.hh config.make Makefile config.cache \
		config.status config.log index.html

local-maintainerclean:
	rm -f configure

Makefile: make/Toplevel.make.in
	chmod +w $@
	echo "# WARNING WARNING WARNING WARNING" > $@
	echo "# do not edit! this is generated from make/Toplevel.make.in" >> $@
	cat $< >> $@
	chmod -w $@

htmldoc: check-www-doc
	$(MAKE) CONFIGSUFFIX='www' local-WWW
	$(MAKE) CONFIGSUFFIX='www' -C Documentation WWW
	rm -f `find . -name \*.html~ -print`
	tar cfz $(outdir)/htmldoc.tar.gz  `find Documentation -type d -name 'out-www' -print` index.html $(shell ls *.gif $(ERRORLOG))


# if you fix this, please fix yodl too!
check-top-web:
	$(MAKE) -C Documentation/topdocs WWW

local-WWW: #index.html 

index.html: check-top-web NEWS
#	$(sed-version) < Documentation/topdocs/$(outdir)/index.html > $@
#	$(PYTHON) $(step-bindir)/add-html-footer.py --package=$(topdir) --index=index.html --news=NEWS $@
	$(sed-version) < Documentation/topdocs/$(outdir)/topweb.html > $@
	$(PYTHON) $(step-bindir)/add-html-footer.py --package=$(topdir) --index=Documentation/top-docs/out-www/index.html $@

WWW-clean:
	$(MAKE) CONFIGSUFFIX='www' clean

