# title	   generic make targets
# file	   make/Targets.make

.PHONY : all clean config default dist doc doc++ dummy exe help html lib TAGS\
	 po

# target all:
#
all:	 default
	$(LOOP)


outdirs: outdir
	$(LOOP)

outdir:
	-mkdir -p $(outdir)

# be careful about deletion.
clean: localclean
	-rm -f $(outdir)/*
	touch $(outdir)/dummy.dep
	$(LOOP)

distclean: clean 
	$(LOOP)
	$(MAKE) local-distclean

maintainerclean: 
	$(LOOP)
	$(MAKE)	local-maintainerclean
	$(MAKE) local-distclean

new-po:
	if test -r $(po-dir); then \
	  rm -f $(po-dir)/$(outdir)/$(package).po; \
	  touch $(po-dir)/$(outdir)/$(package).po; \
	fi

ifeq ($(strip $(depth)),.)
po: new-po
	$(LOOP)
localpo:
	@true
else
po: localpo
	$(LOOP)
ALL_PO_SOURCES = $(ALL_C_SOURCES) $(wildcard $(outdir)/*.hh) $(wildcard $(outdir)/*.cc)
localpo:
ifneq ($(strip $(ALL_PO_SOURCES)),)
	@echo $(ALL_PO_SOURCES)
	xgettext --c++ --default-domain=$(package) --join \
	 --output-dir=$(po-dir)/$(outdir) --add-comments \
	 --keyword=_ --keyword=_f $(ALL_PO_SOURCES)
endif
endif

po-update: po
	$(MAKE) -C $(po-dir) po-update

show-po-changes:
	$(MAKE) -C $(po-dir) show-po-changes

# configure:
#
config:
	./$(depth)/configure
#

# dummydeps:
#
dummydep: $(DUMMYDEPS)
#

# target help:
#
help:
	@echo -e "\
Makefile for $(PACKAGE_NAME) $(TOPLEVEL_VERSION)\n\
Usage: $(MAKE) ["VARIABLE=value"]... [TARGET]\n\
\n\
Targets:\n\
  all         update everything\n\
  clean       remove all genated stuff in $(oudir)\n\
  config      rerun configure\n\
  deb         build Debian package\n\
  default     same as the empty target\n\
  diff        generate patch: $(package)-$(TOPLEVEL_VERSION).diff.gz\n\
  .           Options:\n\
  .             from=0.1.74\n\
  .             help==\n\
  .             release==\n\
  .             to=0.1.74.jcn2\n\
  dist        roll tarball: $(outdir)/$(package)-$(TOPLEVEL_VERSION).tar.gz\n\
  distclean   cleaner than clean (duh)\n\
  doc         update all documentation\n\
  doc++       make doc++ documentation\n\
  exe         update all executables\n\
  help        this help\n\
  install     install programs and data (prefix=$(prefix))\n\
  lib         update all libraries\n\
  release     roll tarball and generate patch\n\
  rpm         build RedHat package\n\
  tar         same as dist\n\
  TAGS        genarate tagfiles\n\
  zip         build binary doze distribution\n\
\n\
Make may be invoked from any subdirectory\n\
Note that all commands recurse into SUBSDIRS\n\
"\
#

doc:
#	$(MAKE) -C $(depth)/Documentation do-doc
	$(MAKE) -C $(depth)/Documentation all


# Ugh.  C++ specific.
doc++:
	(cd $(outdir); sh ../$(step-bindir)/tar-docxx.sh $(package)-$(TOPLEVEL_VERSION).tar.gz)



check-state-vector:
	if [ "`tail -1 $(state-vector)`" != "$(TOPLEVEL_VERSION)" ]; then\
	  echo $(TOPLEVEL_VERSION) >> $(state-vector); \
	fi

# ugh. should generate in out/
dist:	check-dist-deps check-state-vector
	rm -rf $(distdir)
	-mkdir $(distdir)
	$(MAKE) localdist $(distdir)
	chmod -R a+r $(distdir)
	chmod  a+x `find $(distdir) -type d -print` 
	(cd ./$(depth)/$(outdir); $(TAR) cf - $(DIST_NAME) | gzip -9 > $(DIST_NAME).tar.gz)
# ugh.
# Can't compare "stage1" dist with "stage2" dist in this way?
	-ln -f $(depth)/$(outdir)/$(distname).tar.gz $(release-dir)

# should be trapped
	rm -rf ./$(distdir)/

localdist: $(DISTFILES) $(OUT_DISTFILES)
	touch $(outdir)/dummy.dep; \
	mkdir $(distdir)/$(localdir)/out; \
	$(LN) $(DISTFILES) $(distdir)/$(localdir)
	$(LN) $(outdir)/dummy.dep $(OUT_DISTFILES) $(distdir)/$(localdir)/out
	$(foreach i, $(SUBDIRS), mkdir $(distdir)/$(localdir)/$(i); \
	    $(MAKE) distdir=../$(distdir) localdir=$(localdir)/$(i) -C $(i) localdist &&) true



html: $(HTMLFILES)

TAGS:$(all-tag-sources)
ifdef all-tag-sources
	-etags -CT $(all-tag-sources) $(ERROR_LOG)
	-ctags -h ".h.hh.tcc.icc" $(all-tag-sources) $(ERROR_LOG)
endif
	$(LOOP)

$(outdir)/version.hh: VERSION
	sh ./$(step-bindir)/make-version.sh > $@


# should this be in Rules?
configure: configure.in aclocal.m4
	autoconf - < $<> $@
	chmod +x configure

localclean:

local-distclean:

local-maintainerclean:

install-strip:
	$(MAKE) INSTALL="$(INSTALL) -s" install

install: localinstall
	$(LOOP)

localinstall:

uninstall: localuninstall
	$(LOOP)

localuninstall:

installextradoc:
	$(INSTALL) -d $(prefix)/doc/$(package)
	$(foreach i, $(EXTRA_DOCFILES),\
		cp -r $(i) $(prefix)/doc/$(package) &&) true

WWW: local-WWW
	$(LOOP)

include $(stepdir)/Package.make
include $(make-dir)/Targets.make

ifneq ($(DEPFILES),)
include $(DEPFILES)
endif

