# Files.make

# C/C++
# 
# header files:
HFILES := $(wildcard *.h)
HHFILES := $(wildcard *.hh)
# 
# source files:
CFILES := $(wildcard *.c)
CCFILES := $(wildcard *.cc)
#
# inline files:
INLFILES := $(wildcard *.icc)
#
# template files:
TCCFILES := $(wildcard *.tcc)
#
# lex and yacc files:
YFILES := $(wildcard *.y *.l)
YYFILES := $(wildcard *.yy *.ll)
#
EXTRA_SOURCE_FILES = $(YFILES) $(YYFILES)

# All c/c++ source files and headers:
#
ALL_C_SOURCES = $(HFILES) $(HHFILES) $(CFILES) $(CCFILES) $(INLFILES) $(TCCFILES) $(EXTRA_SOURCE_FILES)
#

# list of object files:
#
SOURCE_FILES = $(CFILES) $(CCFILES) $(EXTRA_SOURCE_FILES)
OFILEC = $(SOURCE_FILES:.c=.o)
OFILEL = $(OFILEC:.l=.o)
OFILEY = $(OFILEL:.y=.o)
OFILECC = $(OFILEY:.cc=.o)
OFILELL = $(OFILECC:.ll=.o)
OFILEYY = $(OFILELL:.yy=.o)
OFILES = $(addprefix $(outdir)/,$(OFILEYY))
#

DEPFILES := $(wildcard $(depdir)/*.dep)

all-tag-sources=$(CCFILES) $(HHFILES) $(TCCFILES)

# (Why not Makefile too?)
#
MAKEFILES := $(wildcard *.make)
#

INFILES := $(wildcard *.in)

# Preprocessed .in documentation files:
#
OUTINFILES = $(addprefix $(outdir)/, $(INFILES:%.in=%))
#

ALL_SOURCES = $(ALL_C_SOURCES) $(INFILES) $(MAKEFILES)

