# title	   package specific targets
# file	   make/Targets.make

.PHONY : check-flower-deps check-lib-deps check-rpm-doc-deps 
.PHONY : check-dist-deps check-doc-deps check-make-deps check-rpm-doc-deps check-html-deps check-www-doc

check-dist-deps: check-make-deps

check-doc-deps:
	$(MAKE) -C $(depth)/Documentation

check-html-deps:
	$(MAKE) -C $(depth)/Documentation html

check-www-doc:
	$(MAKE) CONFIGSUFFIX='www' -C Documentation outdirs
	$(MAKE) CONFIGSUFFIX='www' -C Documentation WWW

# specific stuff:
#
$(LIBFLOWER): check-flower-deps

check-flower-deps:
	$(MAKE)  -C $(depth)/flower/ default

check-lib-deps: check-flower-deps
	$(MAKE)  -C $(depth)/lib

$(LIBLILY): dummy
	$(MAKE) ./$(outdir)/$(@F) -C $(depth)/lib

# urg
check-make-deps:
	$(MAKE) -C $(buildscripts)
	$(MAKE) -C $(depth)/make
	$(MAKE) -C $(depth)/debian
	$(MAKE) -C $(stepdir)

check-rpm-icons:
	$(MAKE) -C $(depth)/Documentation/pictures gifs
#	-cp $(wildcard $(depth)/Documentation/$(outdir)/*.gif) $(rpm-sources)
#	-cp $(wildcard $(depth)/Documentation/$(outdir)/*.gif) $(depth)/$(outdir)
# $(wildcard) is expanded before gifs are generated...
	-cp `ls $(depth)/Documentation/pictures/$(outdir)/*.gif $(ERROR_LOG)` $(depth)/$(outdir)

check-mf-deps:
	$(MAKE) -C $(depth)/mf

check-texinfo-deps:
	$(MAKE) -C $(depth)/Documentation texinfo
	$(MAKE) -C $(depth)/Documentation/man texinfo

# urg!
$(configheader): $(depth)/$(configuration).hh
	cp $< $@

