# make/Mutopia.make

FLYFILES = $(wildcard *.fly)
LYFILES = $(wildcard *.ly)
M4FILES = $(wildcard *.m4)
LYM4FILES = $(wildcard *.lym4)
DISTFILES = Makefile $(EXTRA_DISTFILES) $(FLYFILES) $(LYFILES) $(M4FILES) $(LYM4FILES)
#

OUTFILES = $(addprefix $(outdir)/,$(M4FILES:%.m4=%)) \
 $(addprefix $(outdir)/,$(LYM4FILES:%.lym4=%.ly))

all: $(OUTFILES)

name-stem= $(notdir $(basename $<))

$(outdir)/%.gif: $(outdir)/%.ps
	sh $(buildscripts)/ps-to-gifs.sh $<
	-mv $(name-stem)-page*.gif $(outdir)/
	touch $@

$(outdir)/%.ly.txt: %.ly
	ln -f $< $@

$(outdir)/%.fly.txt: %.fly
	ln -f $< $@

# don't junk intermediate .dvi files.  They're easier to view than
# .ps or .gif
.PRECIOUS: $(outdir)/%.dvi
$(outdir)/%.dvi: %.ly
	sh $(depth)/scripts/ly2dvi.sh -o $(outdir)  $< 
	-mv $(basename $<).midi $(outdir)

$(outdir)/%.dvi: %.fly
	sh $(depth)/scripts/ly2dvi.sh -o $(outdir)  $< 
	-mv $(basename $<).midi $(outdir)

