/* macro_fu.h
 *
 * For use with GTKeyboard
 * written by David Allen s2mdalle@titan.vcu.edu
 * http://opop.nols.com/
 *
 * This file is released under the terms of the GNU General Public License.
 */

#define MACRO_FU_H

#ifndef MEM_HEADER_H
#include "mem_header.h"
#endif /* MEM_HEADER_H */

#define MACRO_FU_H

#define MEMMSG(x)                        if(options.VERBOSE){\
                                              fprintf(Q,"%s",x);\
                                              fflush(Q);}
#define TRACE()	                         fprintf(stderr,"(%d %s)\n",\
                                                 __LINE__,__FILE__);\
                                         fflush(stderr);
#define STRACE(n)	                 fprintf(stderr,"(%d %s) [%s]\n",\
                                                 __LINE__,__FILE__,n);\
                                         fflush(stderr);
#define ITRACE(n)	                 fprintf(stderr,"(%d %s) [%d]\n",\
                                                 __LINE__,__FILE__,n);\
                                         fflush(stderr);

#define add_tooltip(addto, text)         if(!GUI.tooltips){\
                                            GUI.tooltips = gtk_tooltips_new();\
                                            gtk_tooltips_set_tip(GUI.tooltips,\
								 addto, text, \
                                                                 NULL);\
                                         } else { gtk_tooltips_set_tip(\
                                                  GUI.tooltips, addto, text, \
                                                  NULL); }

#define CONDFREE(x)                      if(x){  g_free_(x);  x = NULL; }
#define CONDSTYLEFREE(x)                 if(x){  gtk_style_destroy(x); x=NULL;}

#define COND_DESTROY(z)                  if(z) gtk_widget_destroy(z);\
                                         if(options.VERBOSE){\
                                                fprintf(Q,"-destroyed-");\
						fflush(Q);}

#define DUMMY_FILENAME                   "/tmp/GTKeyboard"
#define NOWIDGET                         (GtkWidget *)NULL
#define GENERIC_PACK(container, widget)  gtk_box_pack_start(\
                                         GTK_BOX(container), widget, \
                                         FALSE, FALSE, 0)

#define GTKEYBOARD_MESSAGE_SEPARATOR     gtkeyboard_message(1,\
                                         "<=========================>\n");
#define show_widget(x,y)                 unhide_widget(x,y);
#define FLUSH_EVERYTHING                 fflush(Q); fflush(stdout);\
                                         fflush(stderr);

/* Toggling Defines */
#define ON                               1
#define OFF                              0
#define NO_WIDGET                        (GtkWidget *)NULL
#define KEYSYMS_PER_CODE                 2
/* Whatever the status is, FLIP IT */
#define TOGGLE(x)                        ( x ? x=OFF : x=ON )
#define ISOFF(x)                         ( x==OFF )
#define ISON(x)                          ( x==ON  )

/* In case we ever achieve portability to winblows, we can change this
 * to a backslash.  :)
 */
#define _DIR                             "/"

#define FLUSH                            fflush(Q)
#define NONE                             NULL
#define WIN_NONE                         (Window)NULL

#define LEFT_MOUSE_BUTTON                1
#define RIGHT_MOUSE_BUTTON               3
#define MIDDLE_MOUSE_BUTTON              2

#define Q                                stderr
#define XPM_LOCATION                     "xpm"
#define SPLASH                           "splash.xpm"
#define ABOUT_INFO                       "about.data"
#define README_FILENAME                  "README"
#define CHANGELOG                        "ChangeLog"
#define RC_FILENAME                      ".gtkeyboardrc"
#define COMPLETER_CACHE_FILENAME         ".gtkeyboard-wordcache"
#define PROVIDED_RCFILE            "example_configurations/defaults.gtkeyboard"
#define SHORTCUTS_FILENAME               ".gtkeyboard-shortcuts"
#define LAYOUT_FILENAME                  ".gtkeyboard-layout"
#define APPNAME                          "GTKeyboard"
#define APPURL                           "http://Opop.Nols.Com"
#define CR                               "\n"


#define WIDTH_DECREMENT           800  /* This gets subtracted from the widths
				       * if options.SMALL_WINDOWS is on 
				       * in theory anyway
				       */
#define WIDTH                     630
#define HEIGHT                    550
#define ABOUT_WIDTH               450
#define ABOUT_HEIGHT              400
#define FILE_SELECTION_TITLE      "Open a file"
#define CELL_WIDTH                40
#define CELL_HEIGHT               40
#define GRID_ROWS                 10
#define GRID_COLS                 10

/* Miscellaneous twiddle text knobs */
#define SHIFT_IS_ON               "The Shift key is now ON\n"
#define SHIFT_IS_OFF              "The Shift key is now OFF\n"
#define CAPS_LOCK_IS_ON           "The Caps Lock key is now ON\n"
#define CAPS_LOCK_IS_OFF          "The Caps Lock key is now OFF\n"
#define ALT_GR_IS_ON              "The Alt Gr (Mode Switch) key is now ON\n"
#define ALT_GR_IS_OFF             "The Alt Gr (Mode Switch) key is now OFF\n"
#define CONTROL_IS_OFF            "The Control key is now OFF\n"
#define CONTROL_IS_ON             "The Control key is now ON\n"
#define ALT_IS_OFF                "The Alt key is now OFF\n"
#define ALT_IS_ON                 "The Alt key is now ON\n"
#define STATUS_WIDTH              350
#define STATUS_HEIGHT             125
#define OUTPUT_HEIGHT             250
#define OUTPUT_WIDTH              350

/* Quick function macros */
#define GOTO_EOF                  gtk_text_set_point(GTK_TEXT\
                                  (GUI.main_output_text), 0)

#define GOTO_BOF                  gtk_text_set_point(GTK_TEXT\
                                  (GUI.main_output_text), \
                                     gtk_text_get_length(GTK_TEXT\
				        (GUI.main_output_text)))

#define CLEAR_ALL                 gtk_editable_delete_text(\
                                  GTK_EDITABLE(GUI.main_output_text), 0, -1)

#define FREEZE(foo)               gtk_text_freeze(GTK_TEXT(foo))

#define THAW(foo)                 gtk_text_thaw(GTK_TEXT(foo))


