/* drawing context using the Xlib library.

   Copyright (C) 1995 Free Software Foundation, Inc.

   Written by:  Adam Fedor <fedor@gnu.org>
   Date: Nov 1998
   
   This file is part of the GNU Objective C User Interface library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
   */

/* This is a reasonable attempt at mapping PostScript operators to an
   Xlib library implementation. Don't even begin to think that this
   is a full PostScript implementation, however. Many, many operators are
   not implemented or do not work as expected. Before using an operator,
   check to make sure it is implemented, otherwise the opstack may 
   be screwed up and nothing else will work!. No errors are returned
   for non-implmeneted operators.
*/

#ifndef _XGContext_h_INCLUDE
#define _XGContext_h_INCLUDE

#include <Foundation/NSArray.h>
#include <Foundation/NSGeometry.h>
#include <AppKit/AppKit.h>

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

/* HACKS
 *
 * For the time being, we still need to have several backend classes use the
 * poseAs: mechanism.
 * For tidyness, we declare the class interfaces here rather than in separate
 * header files.
 * As the backend classes are removed, their interfaces will be removed too.
 */

@interface NSBitmapImageRep (BackEnd)
- (Pixmap) xPixmapMask;
@end

@interface	XGDragView : NSView <NSDraggingInfo>
{
  
  NSCell         *dragCell;
  NSPasteboard   *dragPasteboard;
  NSPoint         dragPoint;
  int             dragSequence;
  id              dragSource;
  NSDragOperation dragMask;
  id              dragWindow;
  Atom           *typelist;

  BOOL            dragLocal;
}

+ (XGDragView*) sharedDragView;

- (void) setDragInfoFromEvent: (NSEvent *)event;
@end

/*
 *	Declare all the backend classes here.
 */

@class  XGBitmapImageRep;
@class  XGCachedImageRep;
@class  XGFont;
@class  XGFontManager;
@class  XGImage;
@class  XGGState;

/*
 * Enumerated type to say how we should draw pixels to the X display - used
 * to select different drawing mechanisms to try to optimise.
 */
typedef enum {
  XGDM_FAST15,
  XGDM_FAST16,
  XGDM_FAST32,
  XGDM_FAST32_BGR,
  XGDM_PORTABLE
} XGDrawMechanism;

typedef enum {
  alloc_local, alloc_global
} alloc_mode_t;

@interface XGContext : NSGraphicsContext
{
@public
  void			*opstack;
  void			*gstack;
  XGGState		*gstate;
  NSMutableArray	*ulist;
  NSMutableArray	*fontid;

  void			*context;
  Window		appRootWindow;
  Window		grabWindow;
  alloc_mode_t		alloc_mode;
  NSMutableArray	*windowList;
  XGDrawMechanism	drawMechanism;
  unsigned		lastKeyFlags;
  Time			lastTime;
  Time			lastClick;
  Time			lastMotion;
  Atom			protocols_atom;
  Atom			delete_win_atom;
  Atom			take_focus_atom;
}

+ (Display*) currentXDisplay;
- (XGDrawMechanism) drawMechanism;
- (Display*)xDisplay;
- (void)setXDisplay:(Display *)xdisplay;
- (Window)xDisplayRootWindow;
- (Window)xAppRootWindow;

- (XColor)xColorFromColor: (XColor)color;

- (void *) xrContext;
- (XGGState *) xrCurrentGState;
- (XGGState *) xrGStateWithIdent: (int)gst;

@end

/*
 * Synchronize with X event queue - soak up events.
 * Waits for up to 1 second for event.
 */
@interface XGContext (XSync)
- (BOOL) xSyncMap: (void*)window;
@end


/*
 * Guesses at borders provided by X window manager.
 */
#define	GUESSX	0
#define	GUESSY	22

#endif /* _XGContext_h_INCLUDE */
