/* 
   XGCursor.m

   NSCursor for GNUstep GUI X/GPS Backend

   Copyright (C) 1996 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: March 1996
   
   This file is part of the GNUstep GUI X/GPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include <config.h>

#include <X11/cursorfont.h>
#include <gnustep/xgps/XGContext.h>


//
// Backend structure for XGCursor
//
typedef struct _XGCursor_struct
{
  Cursor cursor;
  BOOL is_valid;
} XGCursor_struct;

#define XCURSOR (((XGCursor_struct *)be_cursor_reserved)->cursor)
#define XVALID (((XGCursor_struct *)be_cursor_reserved)->is_valid)

static char xgps_blank_cursor_bits [] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

//
// Class variables
//
static NSCursor *xgps_blank_cursor = nil;
static NSCursor *xgps_hidden_cursor = nil;



@implementation XGCursor

+ (void)initialize
{
	if (self == [XGCursor class])
		[self setVersion:1];								// Initial version
}

//
// X Window private methods
//
- (void)setXCursor:(Cursor)cursor
{
	XCURSOR = cursor;
	XVALID = YES;
}

- (Cursor)xCursor
{
  // If the xCursor isn't valid
  // then try to create it from the image
  if (!XVALID)
    {
#if 0
      NSApplication *theApp = [NSApplication sharedApplication];
      NSWindow *w = [theApp mainWindow];
      Pixmap shape, mask;
      XColor black, white;
      Window win;

      if (w)
        win = [(XGWindow *)w xWindow];
      else
        {
          XGContext* context = (XGContext *)[XGContext currentContext];
          win = [context xAppRootWindow];
        }

      shape = XCreatePixmapFromBitmapData(xDisplay, win,
					  cursor_bits, 16, 16, 1, 0, 1);
      mask = XCreatePixmapFromBitmapData(xDisplay, win,
					 cursor_bits, 16, 16, 1, 0, 1);
      black = [(XGColor *)[NSColor blackColor] xColor];
      white = [(XGColor *)[NSColor whiteColor] xColor];

      XCURSOR = XCreatePixmapCursor(xDisplay, shape, mask, 
				    &white, &black, 0, 0);
      XVALID = YES;
#endif
    }

  return XCURSOR;
}

- (BOOL)xCursorIsValid
{
	return XVALID;
}

//
// Class methods
//

//
// Setting the Cursor
//
+ (void)hide
{
	if (!xgps_blank_cursor)							// Create the blank cursor 
		{											// if necessary
		Display *xDisplay = [XGContext currentXDisplay];
		NSApplication *theApp = [NSApplication sharedApplication];
		NSWindow *w = [theApp mainWindow];
		Pixmap shape, mask;
		XColor black, white;
		Cursor c;
        Window win;

        if (w)
            win = [(XGWindow *)w xWindow];
        else
            {
            XGContext* context = (XGContext *)[XGContext currentContext];
            win = [context xAppRootWindow];
            }
	
		xgps_blank_cursor = [[NSCursor alloc] initWithImage: nil];
	
		shape = XCreatePixmapFromBitmapData(xDisplay, win,
											xgps_blank_cursor_bits, 
											16, 16, 1, 0, 1);
		mask = XCreatePixmapFromBitmapData(xDisplay, win,
											xgps_blank_cursor_bits, 
											16, 16, 1, 0, 1);
		black = [(XGColor *)[NSColor blackColor] xColor];
		white = [(XGColor *)[NSColor whiteColor] xColor];
	
		c = XCreatePixmapCursor(xDisplay, shape, mask, &white, &black, 0, 0);
		[(XGCursor *)xgps_blank_cursor setXCursor: c];
		}
													// If the cursor is already 
	if (xgps_blank_cursor == [self currentCursor])	// hidden then don't hide 
		return;										// again.

	xgps_hidden_cursor = [self currentCursor];		// Save the current cursor 
	[xgps_blank_cursor set];						// and set the blank cursor
}

+ (void)unhide
{
	if (!xgps_blank_cursor)							// if no blank cursor then 
		return;										// we couldn't have hidden
	
	if (xgps_blank_cursor != [self currentCursor])	// If cursor isn't hidden 
		return;										// then just return
	
	[xgps_hidden_cursor set];						// Set back to the current
}													// cursor

//
// Getting the Cursor
//
+ (NSCursor *)arrowCursor
{
NSCursor *cur;
Cursor c;											// Create the standard left 
													// pointer arrow
	cur = [[[NSCursor alloc] initWithImage: nil] autorelease];
	c = XCreateFontCursor([XGContext currentXDisplay], XC_left_ptr);
	[(XGCursor *)cur setXCursor: c];
	
	return cur;
}

+ (NSCursor *)IBeamCursor
{
NSCursor *cur;
Cursor c;
													// Create standard I beam
	cur = [[[NSCursor alloc] initWithImage: nil] autorelease];
	c = XCreateFontCursor([XGContext currentXDisplay], XC_xterm);
	[(XGCursor *)cur setXCursor: c];
	
	return cur;
}

//
// Instance methods
//

//
// Initializing a New NSCursor Object
//
- (id)initWithImage:(NSImage *)newImage
{
	[super initWithImage: newImage];
															// Allocate backend
	be_cursor_reserved = malloc(sizeof(XGCursor_struct));	// structure
	XCURSOR = 0;
	XVALID = NO;
	
	return self;
}

- (void)dealloc
{
	free(be_cursor_reserved);						// Free backend structure
	[super dealloc];
}

@end

//
// Backend Methods
//
@implementation XGCursor (GNUstepBackend)

+ (void)currentCursorHasChanged
{
NSCursor *c = [self currentCursor];
BOOL isValidXCursor = [(XGCursor *)c xCursorIsValid];

	if (isValidXCursor)
		{
		Cursor xc = [(XGCursor *)c xCursor];
		NSApplication *theApp = [NSApplication sharedApplication];
		NSWindow *w = [theApp mainWindow];
        Window win;

        if (w)
            win = [(XGWindow *)w xWindow];
        else
            {
            XGContext* context = (XGContext *)[XGContext currentContext];
            win = [context xAppRootWindow];
            }

		XDefineCursor([XGContext currentXDisplay],win, xc);
		}
}

- (Class) classForCoder: aCoder
{
  if ([self class] == [XGCursor class])
    return [super class];
  return [self class];
}

@end
