/* 
   PXKBrowserCell.m

   NSBrowserCell for GNUstep GUI X/DPS Backend

   Copyright (C) 1996, 1997 Free Software Foundation, Inc.

   Author:  Scott Christley <scottc@net-community.com>
   Date: March 1996
   
   This file is part of the GNUstep GUI X/DPS Backend.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.
   If not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 

#include "config.h"
#include <gnustep/xdps/PXKBrowserCell.h>
#include <AppKit/NSWindow.h>
#include <AppKit/NSGraphics.h>
#include <AppKit/NSImage.h>
#include <AppKit/NSTextFieldCell.h>
#include <gnustep/xdps/PXKCell.h>
#include <AppKit/NSColor.h>

@implementation PXKBrowserCell

//
// Displaying 
//
- (void)drawInteriorWithFrame:(NSRect)cellFrame
		       inView:(NSView *)controlView
{
  NSRect title_rect = cellFrame;
  NSCell *ic;
  NSRect image_rect = cellFrame;
  NSColor *backColor = [[controlView window] backgroundColor];
  BOOL ch = [self isHighlighted];

  // Save last view drawn to
  control_view = controlView;

  // Clear the background
  if (ch)
    [[NSColor whiteColor] set];
  else
    [backColor set];
  NSRectFill(cellFrame);

  // Determine image rect
  if (![self isLeaf])
    {
      if (ch)
	ic = _highlightBranchImage;
      else
	ic = _branchImage;
      image_rect.size = [[ic image] size];

      // xxx I guess we should make it square?
      image_rect.size.height = cellFrame.size.height;
      image_rect.size.width = image_rect.size.height;

      // Right justify
      image_rect.origin.x += cellFrame.size.width - image_rect.size.width;
    }
  else
    {
      ic = nil;
      image_rect = NSZeroRect;
    }

  // Determine title rect
  title_rect.size.width -= image_rect.size.width + 4;

  // Draw the title cell
  if (ch)
    [_browserText setBackgroundColor: [NSColor whiteColor]];
  else
    [_browserText setBackgroundColor: backColor];
  [_browserText drawWithFrame: title_rect inView: controlView];

  // Draw the image
  if (ic)
    [self _displayImage: [ic image] inFrame: image_rect];
}

- (void)drawWithFrame:(NSRect)cellFrame
	       inView:(NSView *)controlView
{
  // We don't have a border to just draw the interior
  [self drawInteriorWithFrame: cellFrame inView: controlView];
}

- (void)highlight:(BOOL)lit
	withFrame:(NSRect)cellFrame
	   inView:(NSView *)controlView
{
  [super highlight: lit withFrame: cellFrame inView: controlView];
  [self drawInteriorWithFrame: cellFrame inView: controlView];
}

- (Class) classForCoder: aCoder
{
  if ([self class] == [PXKBrowserCell class])
    return [super class];
  return [self class];
}

@end
