#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2003-2009 Free Software Foundation
#
# FILE:
# postscript/Writer.py
#
# DESCRIPTION:
#
# NOTES:
#

__all__ = ['Writer']

from gnue.common.utils.TextUtils import lineWrap
import string, time

from gnue.reports.adapters.filters.Universal.Base.Writers.AbsoluteWriter import *

class Writer(AbsoluteWriter):

  # Supported features
  BITMAP_FORMATS=[]
  VECTOR_FORMATS=['eps']

  def initialize(self):

    # Write headers to file... initialize state variables

    # TODO: support loading of external PPD files
    from psutils.GenericDefinitions.Postscript2Driver import Postscript2Driver
    self.ppd = Postscript2Driver()


    w, h = self.ppd.getPage
    self.handle = handle
    self.ppd = ppd

    self.__pages = 0
    self.__inPage = 0
    self.__currentStyle = None
    self.__usedfonts = {}

    # TODO: send options to PPD

    self._writeHeader()

  def finalize(self):
    # Close the current page, if applicable
    if self.__inPage:
      self.closePage()

    # Write out the postscript trailer
    self.handle.write('%%Trailer\n')
    self.handle.write('%%%%Pages: %s\n' % pages)
    self.handle.write('%%EOF\n')

  def newPage(self):
    # Close the current page, if applicable
    if self.__inPage:
      self.closePage()

    # Keep track of our page status
    self.__inPage = 1

    # Set number of pages
    self.__pages += 1

    handle = self.handle

    handle.write('%%%%Page: %s %s\n' % (self.__pages, self.__pages))
    handle.write('%%BeginPageSetup\n')
    handle.write('/psave save def\n')
    # TODO: Set default coordinates, etc
    handle.write('%%EndPageSetup\n')

  def _closePage(self):
    # Keep track of our page status
    self.__inPage = 0
    self.handle.write("psave restore\n")
    self.handle.write("showpage\n")

  def _writeHeader(self):

    handle = self.handle

    # TODO
    title = "Test Report"

    handle.write(PS_HEADER % (VERSION, title,
                          time.strftime("%Y-%m-%d %H:%M:%S",
                            time.localtime(time.time()))))

    handle.write(self.ppd.getDscComments())
    handle.write(PROLOG_HEADER)

    #
    # Create our procset
    #
    text = "/Bd {bind def} bind"

    for func in _PROCSET.keys():
      text  += " /%s {%s} Bd" % (func, _PROCSET[next][1])

    # Line sizes are limited to 255, but we will
    # wrap at 78 for more readable files. Not
    # that this output is overly readable :^)
    handle.write(lineWrap(text,78,0))

    handle.write(PROLOG_FOOTER)

    handle.write("%%BeginSetup\n")
    handle.write(self.ppd.getDscSetup())
    handle.write("%%EndSetup\n")


PS_HEADER = """\
%%!PS-Adobe-3.0
%%%%Creator: GNUe Reports %s
%%%%Title: %s
%%%%CreationDate: %s
%%%%Pages: (atend)
%%%%DocumentData: Clean7Bit
%%%%DocumentNeededFonts: (atend)
%%%%DocumentSuppliedFonts: (atend)
%%%%LanguageLevel: 2
"""

PROLOG_HEADER = """\
%%%%EndComments
%%%%BeginProlog
%% This copyright applies to everything between here and the %%%%EndProlog:
%% Copyright (C) 2003 Free Software Foundation.  All rights reserved.
%% This code section is subject to the terms of GPL version 2.0.
%%%%BeginResource: procset GNUeReports_Universal_ProcSet %(procsetversion)s 0
/GNUeReports_Universal_ProcSet 40 dict dup begin
"""

PROLOG_FOOTER = """\
end
%%EndResource
%%EndProlog
"""


#########################################################
#
# Define our standard PS procset (procedure toolkit).
# We do it in a dictionary instead of inside the PS_HEADER
# so that we can have more room to write, comment, etc.
# This way, we can write a compacted version to the output
# stream, but code in a more readable format.  The code
# adds the necessary 'Proc { <code> } def' wrapper.
#
_PROCSET = {
#
# SetFont
# Syntax:  <fontname> Ft
#
'Ft' : ( 'SetFont', """
findfont
"""),

#
# NewPage
# Syntax:  Np
#
'Np' : ( 'NewPage', """
newpage
"""),

}

#
# Build a reverse lookup for _PROCSET
#
_PROCSETREV = {}
for key, pairs in _PROCSET.items():
  if _PROCSETREV.has_key(pairs[0]):
    raise "Programming Error: Duplicate procset definition for %s" % pairs[0]
  _PROCSETREV[pairs[0]] = key
