# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# $Id: scrollbar.py 9956 2009-10-11 18:54:57Z reinhard $
#
# DESCRIPTION:
# A wxPython based user interface driver for GNUe forms.
#
# NOTES:
#

import struct

import win32gui
import win32con

from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Window
from gnue.forms.uidrivers.win32.common import getNextId

# =============================================================================
# Class implementing an UI scroll bar
# =============================================================================

class UIScrollBar (UIHelper):

    # ---------------------------------------------------------------------------
    # Create a new scrollbar widget
    # ---------------------------------------------------------------------------

    def _create_widget (self, event, spacer):

        object = event.object

        style = win32con.WS_CHILD | win32con.WS_VISIBLE | win32con.SBS_VERT | \
                win32con.SBS_LEFTALIGN
        styleEx = 0

        newWidget = self._widget = Win32Window (self._uiDriver, styleEx,
                            "Scrollbar", "", style,
                            self.itemX, self.itemY,
                            -1, #object.Char__width*event.widgetWidth,
                            object.Char__height*event.widgetHeight,
                            event.container, getNextId ())

        self._hwnd = newWidget.GetHwnd ()

        return newWidget


    # ---------------------------------------------------------------------------
    # Adjust the scrollbar to reflect changed record or record-cound
    # ---------------------------------------------------------------------------

    def _ui_adjust_scrollbar_(self, current, size, count):

        self.pageSize = size
        format = "IIiiIii"
        csize = struct.calcsize (format)
        mask = win32con.SIF_RANGE | win32con.SIF_PAGE | win32con.SIF_POS
        scrollinfo = struct.pack (format, csize, mask, 0, count - 1, size, current,
                0)
        win32gui.SendMessage (self._hwnd, win32con.SBM_SETSCROLLINFO, 1, scrollinfo)


# =============================================================================
# Config dictionary
# =============================================================================

configuration = {
    'baseClass'  : UIScrollBar,
    'provides'   : 'GFScrollBar',
    'container'  : 0,
    }
