# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# $Id: button.py 9956 2009-10-11 18:54:57Z reinhard $
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import win32con

from gnue.common import events
from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Button
from gnue.forms.uidrivers.win32.common import *

#
# UIButton
#
# Widget set specific function that creates a single instance of a button
#
class UIButton(UIHelper):
    def _create_widget(self, event, spacer):
        if self.itemHeight == -1:
            height = event.widgetHeight
        else:
            height = self.itemHeight+4
      
        object = event.object
        style = win32con.BS_PUSHBUTTON | win32con.WS_CHILD
        styleEx = 0
        newWidget = Win32Button(self._uiDriver, styleEx, 'BUTTON', textEncode(object.label), style,
                            self.itemX,
                            self.itemY,
                            self.itemWidth,
                            height,
                            event.container, getNextId())
        if event.initialize:
            event.container.Connect(newWidget.GetId(), self.buttonHandler)

        return newWidget

    def buttonHandler(self, id):
        gfObject = self._uiDriver._IdToGFObj[id]
        gfObject._event_fire ()

    # ---------------------------------------------------------------------------
    # Enable/disable this button
    # ---------------------------------------------------------------------------

    def _ui_enable_(self, index):
        self.widgets[index].Enable(True)

    # ---------------------------------------------------------------------------

    def _ui_disable_(self, index):
        self.widgets[index].Enable(False)


configuration = {
    'baseClass'  : UIButton,
    'provides'   : 'GFButton',
    'container'  : 0,
    }
