# Short line describing the purpose of this file
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: menuitem.py 9956 2009-10-11 18:54:57Z reinhard $

import qt

from gnue.forms.uidrivers.qt3.widgets._base import UIHelper

# =============================================================================
# Wrap an UI layer around a menu item
# =============================================================================

class UIMenuItem(UIHelper):
    """
    Implements a menu item object.
    """

    # -------------------------------------------------------------------------
    # Create a menu item widget
    # -------------------------------------------------------------------------

    def _create_widget_(self, event, spacer):
        """
        Creates a new MenuItem widget.
        """

        # These are the relevant parameters
        icon_file = self._gfObject._get_icon_file(size="16x16", format="png")
        label = self._gfObject.label
        description = self._gfObject.description
        hotkey = self._gfObject.hotkey
        check = (self._gfObject.action_off is not None)

        self.parent = event.container

        if label is not None:
            if icon_file:
                icon = qt.QIconSet(qt.QPixmap(icon_file))
                self.__widget = self.parent.insertItem(icon, label,
                        self.__on_menu)
            else:
                self.__widget = self.parent.insertItem(label, self.__on_menu)

            if hotkey is not None:
                parts = hotkey.split("+")
                if len(parts[-1]) == 1:
                    base = ord(parts[-1])
                else:
                    base = self.__keymap[parts[-1]]
                mod = 0
                if "SHIFT" in parts: mod = mod | qt.Qt.SHIFT
                if "CTRL"  in parts: mod = mod | qt.Qt.CTRL
                if "ALT"   in parts: mod = mod | qt.Qt.ALT

                self.parent.setAccel(qt.QKeySequence(base | mod), self.__widget)

            self.parent.setWhatsThis(self.__widget, description or '')
        else:
            self.__widget = None
            self.parent.insertSeparator()

        return self.__widget



    # -------------------------------------------------------------------------
    # Events
    # -------------------------------------------------------------------------

    def __on_menu(self, *args):

        self._gfObject._event_fire()


    # -------------------------------------------------------------------------
    # Check/uncheck menu item
    # -------------------------------------------------------------------------

    def _ui_switch_on_(self):

        if self.__widget is not None:
            self.parent.setItemChecked(self.__widget, True)

    # -------------------------------------------------------------------------

    def _ui_switch_off_(self):

        if self.__widget is not None:
            self.parent.setItemChecked(self.__widget, False)


    # -------------------------------------------------------------------------
    # Enable/disable menu item
    # -------------------------------------------------------------------------

    def _ui_enable_(self):

        if self.__widget is not None:
            self.parent.setItemEnabled(self.__widget, True)

    # -------------------------------------------------------------------------

    def _ui_disable_(self):

        if self.__widget is not None:
            self.parent.setItemEnabled(self.__widget, False)


    # -------------------------------------------------------------------------
    # The keymap for hotkeys
    # -------------------------------------------------------------------------

    __keymap = {
        "F1"        : qt.Qt.Key_F1,
        "F2"        : qt.Qt.Key_F2,
        "F3"        : qt.Qt.Key_F3,
        "F4"        : qt.Qt.Key_F4,
        "F5"        : qt.Qt.Key_F5,
        "F6"        : qt.Qt.Key_F6,
        "F7"        : qt.Qt.Key_F7,
        "F8"        : qt.Qt.Key_F8,
        "F9"        : qt.Qt.Key_F9,
        "F10"       : qt.Qt.Key_F10,
        "F11"       : qt.Qt.Key_F11,
        "F12"       : qt.Qt.Key_F12,
        "INS"       : qt.Qt.Key_Insert,
        "DEL"       : qt.Qt.Key_Delete,
        "HOME"      : qt.Qt.Key_Home,
        "END"       : qt.Qt.Key_End,
        "PGUP"      : qt.Qt.Key_Prior,
        "PGDN"      : qt.Qt.Key_Next,
        "UP"        : qt.Qt.Key_Up,
        "DOWN"      : qt.Qt.Key_Down,
        "LEFT"      : qt.Qt.Key_Left,
        "RIGHT"     : qt.Qt.Key_Right,
        "TAB"       : qt.Qt.Key_Tab,
        "ENTER"     : qt.Qt.Key_Return,
        "BACK"      : qt.Qt.Key_BackSpace}


# =============================================================================
# Configuration data
# =============================================================================

configuration = {
  'baseClass': UIMenuItem,
  'provides' : 'GFMenuItem',
  'container': False
}

