# GNU Enterprise Forms - GF Object Hierarchy - Scrollbar
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: GFScrollBar.py 10016 2009-10-28 14:41:59Z reinhard $
"""
Class implementing scrollbars for controlling record positions within blocks
"""

from gnue.common.apps import errors
from gnue.forms.GFObjects.GFObj import GFObj


# =============================================================================
# GFScrollBar
# =============================================================================

class GFScrollBar(GFObj):
  
    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self, parent=None):

        GFObj.__init__ (self, parent, 'GFScrollBar')

        self.label = ""
        self._scrollrows  = 1


    # -------------------------------------------------------------------------
    # Phase I init: find the parent GFForm and the bound GFBlock
    # -------------------------------------------------------------------------

    def _phase_1_init_(self):

        GFObj._phase_1_init_(self)

        self._block.register_scrollbar(self)

        self._scrollrows = getattr(self, 'scrollrows', self._block._rows)


    # -------------------------------------------------------------------------
    # Call the UI widget to adjust the scrollbar to a given position
    # -------------------------------------------------------------------------

    def adjust_scrollbar(self, current, count):
        """
        Update the UI scrollbar to reflect a new position or record-count.

        @param current: current first visible record number in the block
        @param count: number of records in the block
        """

        if self.uiWidget is not None:
            self.uiWidget._ui_adjust_scrollbar_(current, self._scrollrows,
                    count)


    # -------------------------------------------------------------------------
    # Jump to a record relative to the current record
    # -------------------------------------------------------------------------

    def _event_scrollDelta(self, delta):
        """
        Move the record pointer of the block relative to the current record.
        @param delta: number of records to be moved (can be negative)
        """

        self._block._event_scroll_delta(delta)


    # -------------------------------------------------------------------------
    # Jump to a given record number
    # -------------------------------------------------------------------------

    def _event_scrollToRecord(self, recordNumber):
        """
        Move the record pointer of the block to an absolute position.
        @param recordNumber: number of record to jump to.
        """

        self._block._event_scroll_to_record(recordNumber)
