#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# $Id
#

import os
import sys
import win32con
from win32api import *
from win32gui import *

if hasattr(sys, 'frozen'):
  sys.path.append(os.path.abspath(os.path.dirname(sys.argv[0])))

import gnue.paths

from gnue.common.rpc import server
from gnue.common.apps.GServerApp import GServerApp
from gnue.appserver.geasRpcServer import geasRpcServerApp
from gnue.appserver import VERSION


class MainWindow:
  def __init__(self):
    msg_TaskbarRestart = RegisterWindowMessage("TaskbarCreated");
    message_map = {
        msg_TaskbarRestart: self.OnRestart,
        win32con.WM_DESTROY: self.OnDestroy,
        win32con.WM_COMMAND: self.OnCommand,
        win32con.WM_USER+20 : self.OnTaskbarNotify,
        }
    # Register the Window class.
    wc = WNDCLASS()
    hinst = wc.hInstance = GetModuleHandle(None)
    wc.lpszClassName = "AppserverTaskbar"
    wc.style = win32con.CS_VREDRAW | win32con.CS_HREDRAW;
    wc.hCursor = LoadCursor( 0, win32con.IDC_ARROW )
    wc.hbrBackground = win32con.COLOR_WINDOW
    wc.lpfnWndProc = message_map # could also specify a wndproc.
    classAtom = RegisterClass(wc)
    # Create the Window.
    style = win32con.WS_OVERLAPPED | win32con.WS_SYSMENU
    self.hwnd = CreateWindow( classAtom, "", style, \
        0, 0, win32con.CW_USEDEFAULT, win32con.CW_USEDEFAULT, \
        0, 0, hinst, None)
    UpdateWindow(self.hwnd)
    self._DoCreateIcons()
  def _DoCreateIcons(self):
    # Try and find a custom icon
    hinst =  GetModuleHandle(None)
    iconPathName = os.path.abspath(os.path.join( os.path.split(sys.executable)[0], "pyc.ico" ))
    if not os.path.isfile(iconPathName):
      # Look in the source tree.
      iconPathName = os.path.abspath(os.path.join( os.path.split(sys.executable)[0], "..\\PC\\pyc.ico" ))
    if os.path.isfile(iconPathName):
      icon_flags = win32con.LR_LOADFROMFILE | win32con.LR_DEFAULTSIZE
      hicon = LoadImage(hinst, iconPathName, win32con.IMAGE_ICON, 0, 0, icon_flags)
    else:
      print "Can't find a Python icon file - using default"
      hicon = LoadIcon(0, win32con.IDI_APPLICATION)

    flags = NIF_ICON | NIF_MESSAGE | NIF_TIP
    nid = (self.hwnd, 0, flags, win32con.WM_USER+20, hicon, "")
    Shell_NotifyIcon(NIM_ADD, nid)

  def OnRestart(self, hwnd, msg, wparam, lparam):
    self._DoCreateIcons()

  def OnDestroy(self, hwnd, msg, wparam, lparam):
    nid = (self.hwnd, 0)
    Shell_NotifyIcon(NIM_DELETE, nid)
    PostQuitMessage(0) # Terminate the app.

  def OnTaskbarNotify(self, hwnd, msg, wparam, lparam):
    if lparam==win32con.WM_RBUTTONUP:
      menu = CreatePopupMenu()
      AppendMenu( menu, win32con.MF_STRING, 1024, u_("About...") )
      AppendMenu( menu, win32con.MF_STRING, 1025, u_("Shutdown GNUe-Appserver") )
      pos = GetCursorPos()
      # See http://msdn.microsoft.com/library/default.asp?url=/library/en-us/winui/menus_0hdi.asp
      SetForegroundWindow(self.hwnd)
      TrackPopupMenu(menu, win32con.TPM_LEFTALIGN, pos[0], pos[1], 0, self.hwnd, None)
      PostMessage(self.hwnd, win32con.WM_NULL, 0, 0)
    return 1

  def OnCommand(self, hwnd, msg, wparam, lparam):
    id = LOWORD(wparam)
    if id == 1024:
      flags = win32con.MB_TASKMODAL | win32con.MB_OK #| win32con.MB_ICONINFORMATION
      message = 'GNUe Application Server\n\n' + 'version: ' + VERSION
      MessageBox(0, message, u_("About"), flags)
    elif id == 1025:
      print o(u_("Appserver is shutting down....ok"))
      DestroyWindow(self.hwnd)


class geasRpcServerWinApp(geasRpcServerApp):
  def run (self):
    # Create the various servers
    servers = server.bind (gnue.paths.data + '/share/gnue/grpc/appserver.grpc',
                           self._transports,
                           {'SessionManager': self.requestSessionManager})

    # be verbose
    print o(u_("\n... GNUe Application Server up and running ...\n"))

    # Daemonize (if appropriate)
    GServerApp.run (self)

    # Start the server for the different protocolls
    for key in servers.keys ():
      servers [key].serveAsNewThread ()

    w=MainWindow()
    PumpMessages()


if __name__=='__main__':
  wserver = geasRpcServerWinApp ()
  wserver.phaseInit ()
  wserver.run ()
