/* unixmail.h -- Structures and Functions appearing in unixmail.c

   Copyright (C) 1989 Free Software Foundation
   Authored by Brian Fox

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* Structure containing header tags and values. */
typedef struct {
  char *tag;
  char *value;
} HEADER;

/* Functions appearing in unixmail.c */
extern char **from_headers ();
extern char *displayable_string (), *header_value (), *parse_sender ();
extern HEADER **snarf_headers ();
extern void strip_whitespace (), free_headers ();
extern int stricmp ();
extern void *xmalloc (), *xrealloc ();

