#ifndef	_tioctl_user_
#define	_tioctl_user_

/* Module tioctl */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>
#include <hurd/ioctl_types.h>

/* Routine tioctl_tiocmodg */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocmodg
#if	defined(LINTLIBRARY)
    (reqport, state)
	io_t reqport;
	int *state;
{ return __tioctl_tiocmodg(reqport, state); }
#else
(
	io_t reqport,
	int *state
);
#endif

/* Routine tioctl_tiocmods */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocmods
#if	defined(LINTLIBRARY)
    (reqport, state)
	io_t reqport;
	int state;
{ return __tioctl_tiocmods(reqport, state); }
#else
(
	io_t reqport,
	int state
);
#endif

/* Routine tioctl_tiocexcl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocexcl
#if	defined(LINTLIBRARY)
    (reqport)
	io_t reqport;
{ return __tioctl_tiocexcl(reqport); }
#else
(
	io_t reqport
);
#endif

/* Routine tioctl_tiocnxcl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocnxcl
#if	defined(LINTLIBRARY)
    (reqport)
	io_t reqport;
{ return __tioctl_tiocnxcl(reqport); }
#else
(
	io_t reqport
);
#endif

/* Routine tioctl_tiocflush */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocflush
#if	defined(LINTLIBRARY)
    (reqport, queue_selector)
	io_t reqport;
	int queue_selector;
{ return __tioctl_tiocflush(reqport, queue_selector); }
#else
(
	io_t reqport,
	int queue_selector
);
#endif

/* Routine tioctl_tiocgeta */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocgeta
#if	defined(LINTLIBRARY)
    (port, modes, ccs, speeds)
	io_t port;
	modes_t modes;
	ccs_t ccs;
	speeds_t speeds;
{ return __tioctl_tiocgeta(port, modes, ccs, speeds); }
#else
(
	io_t port,
	modes_t modes,
	ccs_t ccs,
	speeds_t speeds
);
#endif

/* Routine tioctl_tiocseta */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocseta
#if	defined(LINTLIBRARY)
    (port, modes, ccs, speeds)
	io_t port;
	modes_t modes;
	ccs_t ccs;
	speeds_t speeds;
{ return __tioctl_tiocseta(port, modes, ccs, speeds); }
#else
(
	io_t port,
	modes_t modes,
	ccs_t ccs,
	speeds_t speeds
);
#endif

/* Routine tioctl_tiocsetaw */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocsetaw
#if	defined(LINTLIBRARY)
    (port, modes, ccs, speeds)
	io_t port;
	modes_t modes;
	ccs_t ccs;
	speeds_t speeds;
{ return __tioctl_tiocsetaw(port, modes, ccs, speeds); }
#else
(
	io_t port,
	modes_t modes,
	ccs_t ccs,
	speeds_t speeds
);
#endif

/* Routine tioctl_tiocsetaf */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocsetaf
#if	defined(LINTLIBRARY)
    (port, modes, ccs, speeds)
	io_t port;
	modes_t modes;
	ccs_t ccs;
	speeds_t speeds;
{ return __tioctl_tiocsetaf(port, modes, ccs, speeds); }
#else
(
	io_t port,
	modes_t modes,
	ccs_t ccs,
	speeds_t speeds
);
#endif

/* Routine tioctl_tiocgetd */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocgetd
#if	defined(LINTLIBRARY)
    (port, discipline)
	io_t port;
	int *discipline;
{ return __tioctl_tiocgetd(port, discipline); }
#else
(
	io_t port,
	int *discipline
);
#endif

/* Routine tioctl_tiocsetd */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocsetd
#if	defined(LINTLIBRARY)
    (port, discipline)
	io_t port;
	int discipline;
{ return __tioctl_tiocsetd(port, discipline); }
#else
(
	io_t port,
	int discipline
);
#endif

/* Routine tioctl_tiocdrain */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocdrain
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return __tioctl_tiocdrain(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocsig */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocsig
#if	defined(LINTLIBRARY)
    (port, signal)
	io_t port;
	int signal;
{ return __tioctl_tiocsig(port, signal); }
#else
(
	io_t port,
	int signal
);
#endif

/* Routine tioctl_tiocext */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocext
#if	defined(LINTLIBRARY)
    (port, mode)
	io_t port;
	int mode;
{ return __tioctl_tiocext(port, mode); }
#else
(
	io_t port,
	int mode
);
#endif

/* Routine tioctl_tiocucntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocucntl
#if	defined(LINTLIBRARY)
    (port, set_or_clear)
	io_t port;
	int set_or_clear;
{ return __tioctl_tiocucntl(port, set_or_clear); }
#else
(
	io_t port,
	int set_or_clear
);
#endif

/* Routine tioctl_tiocswinsz */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocswinsz
#if	defined(LINTLIBRARY)
    (port, sizes)
	io_t port;
	winsize_t sizes;
{ return __tioctl_tiocswinsz(port, sizes); }
#else
(
	io_t port,
	winsize_t sizes
);
#endif

/* Routine tioctl_tiocgwinsz */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocgwinsz
#if	defined(LINTLIBRARY)
    (port, sizes)
	io_t port;
	winsize_t *sizes;
{ return __tioctl_tiocgwinsz(port, sizes); }
#else
(
	io_t port,
	winsize_t *sizes
);
#endif

/* Routine tioctl_tiocremote */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocremote
#if	defined(LINTLIBRARY)
    (port, on_or_off)
	io_t port;
	int on_or_off;
{ return __tioctl_tiocremote(port, on_or_off); }
#else
(
	io_t port,
	int on_or_off
);
#endif

/* Routine tioctl_tiocmget */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocmget
#if	defined(LINTLIBRARY)
    (port, bits)
	io_t port;
	int *bits;
{ return __tioctl_tiocmget(port, bits); }
#else
(
	io_t port,
	int *bits
);
#endif

/* Routine tioctl_tiocmbic */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocmbic
#if	defined(LINTLIBRARY)
    (port, bits)
	io_t port;
	int bits;
{ return __tioctl_tiocmbic(port, bits); }
#else
(
	io_t port,
	int bits
);
#endif

/* Routine tioctl_tiocmbis */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocmbis
#if	defined(LINTLIBRARY)
    (port, bits)
	io_t port;
	int bits;
{ return __tioctl_tiocmbis(port, bits); }
#else
(
	io_t port,
	int bits
);
#endif

/* Routine tioctl_tiocmset */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocmset
#if	defined(LINTLIBRARY)
    (port, bits)
	io_t port;
	int bits;
{ return __tioctl_tiocmset(port, bits); }
#else
(
	io_t port,
	int bits
);
#endif

/* Routine tioctl_tiocstart */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocstart
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return __tioctl_tiocstart(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocstop */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocstop
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return __tioctl_tiocstop(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocpkt */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocpkt
#if	defined(LINTLIBRARY)
    (port, on_or_off)
	io_t port;
	int on_or_off;
{ return __tioctl_tiocpkt(port, on_or_off); }
#else
(
	io_t port,
	int on_or_off
);
#endif

/* Routine tioctl_tiocsti */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocsti
#if	defined(LINTLIBRARY)
    (port, datum)
	io_t port;
	char datum;
{ return __tioctl_tiocsti(port, datum); }
#else
(
	io_t port,
	char datum
);
#endif

/* Routine tioctl_tiocoutq */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocoutq
#if	defined(LINTLIBRARY)
    (port, queue_size)
	io_t port;
	int *queue_size;
{ return __tioctl_tiocoutq(port, queue_size); }
#else
(
	io_t port,
	int *queue_size
);
#endif

/* Routine tioctl_tiocspgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocspgrp
#if	defined(LINTLIBRARY)
    (port, pgrp)
	io_t port;
	int pgrp;
{ return __tioctl_tiocspgrp(port, pgrp); }
#else
(
	io_t port,
	int pgrp
);
#endif

/* Routine tioctl_tiocgpgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocgpgrp
#if	defined(LINTLIBRARY)
    (port, pgrp)
	io_t port;
	int *pgrp;
{ return __tioctl_tiocgpgrp(port, pgrp); }
#else
(
	io_t port,
	int *pgrp
);
#endif

/* Routine tioctl_tioccdtr */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tioccdtr
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return __tioctl_tioccdtr(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocsdtr */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocsdtr
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return __tioctl_tiocsdtr(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tioccbrk */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tioccbrk
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return __tioctl_tioccbrk(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocsbrk */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __tioctl_tiocsbrk
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return __tioctl_tiocsbrk(port); }
#else
(
	io_t port
);
#endif


/* Module tioctl */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>
#include <hurd/ioctl_types.h>

/* Routine tioctl_tiocmodg */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocmodg
#if	defined(LINTLIBRARY)
    (reqport, state)
	io_t reqport;
	int *state;
{ return tioctl_tiocmodg(reqport, state); }
#else
(
	io_t reqport,
	int *state
);
#endif

/* Routine tioctl_tiocmods */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocmods
#if	defined(LINTLIBRARY)
    (reqport, state)
	io_t reqport;
	int state;
{ return tioctl_tiocmods(reqport, state); }
#else
(
	io_t reqport,
	int state
);
#endif

/* Routine tioctl_tiocexcl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocexcl
#if	defined(LINTLIBRARY)
    (reqport)
	io_t reqport;
{ return tioctl_tiocexcl(reqport); }
#else
(
	io_t reqport
);
#endif

/* Routine tioctl_tiocnxcl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocnxcl
#if	defined(LINTLIBRARY)
    (reqport)
	io_t reqport;
{ return tioctl_tiocnxcl(reqport); }
#else
(
	io_t reqport
);
#endif

/* Routine tioctl_tiocflush */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocflush
#if	defined(LINTLIBRARY)
    (reqport, queue_selector)
	io_t reqport;
	int queue_selector;
{ return tioctl_tiocflush(reqport, queue_selector); }
#else
(
	io_t reqport,
	int queue_selector
);
#endif

/* Routine tioctl_tiocgeta */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocgeta
#if	defined(LINTLIBRARY)
    (port, modes, ccs, speeds)
	io_t port;
	modes_t modes;
	ccs_t ccs;
	speeds_t speeds;
{ return tioctl_tiocgeta(port, modes, ccs, speeds); }
#else
(
	io_t port,
	modes_t modes,
	ccs_t ccs,
	speeds_t speeds
);
#endif

/* Routine tioctl_tiocseta */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocseta
#if	defined(LINTLIBRARY)
    (port, modes, ccs, speeds)
	io_t port;
	modes_t modes;
	ccs_t ccs;
	speeds_t speeds;
{ return tioctl_tiocseta(port, modes, ccs, speeds); }
#else
(
	io_t port,
	modes_t modes,
	ccs_t ccs,
	speeds_t speeds
);
#endif

/* Routine tioctl_tiocsetaw */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocsetaw
#if	defined(LINTLIBRARY)
    (port, modes, ccs, speeds)
	io_t port;
	modes_t modes;
	ccs_t ccs;
	speeds_t speeds;
{ return tioctl_tiocsetaw(port, modes, ccs, speeds); }
#else
(
	io_t port,
	modes_t modes,
	ccs_t ccs,
	speeds_t speeds
);
#endif

/* Routine tioctl_tiocsetaf */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocsetaf
#if	defined(LINTLIBRARY)
    (port, modes, ccs, speeds)
	io_t port;
	modes_t modes;
	ccs_t ccs;
	speeds_t speeds;
{ return tioctl_tiocsetaf(port, modes, ccs, speeds); }
#else
(
	io_t port,
	modes_t modes,
	ccs_t ccs,
	speeds_t speeds
);
#endif

/* Routine tioctl_tiocgetd */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocgetd
#if	defined(LINTLIBRARY)
    (port, discipline)
	io_t port;
	int *discipline;
{ return tioctl_tiocgetd(port, discipline); }
#else
(
	io_t port,
	int *discipline
);
#endif

/* Routine tioctl_tiocsetd */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocsetd
#if	defined(LINTLIBRARY)
    (port, discipline)
	io_t port;
	int discipline;
{ return tioctl_tiocsetd(port, discipline); }
#else
(
	io_t port,
	int discipline
);
#endif

/* Routine tioctl_tiocdrain */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocdrain
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return tioctl_tiocdrain(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocsig */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocsig
#if	defined(LINTLIBRARY)
    (port, signal)
	io_t port;
	int signal;
{ return tioctl_tiocsig(port, signal); }
#else
(
	io_t port,
	int signal
);
#endif

/* Routine tioctl_tiocext */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocext
#if	defined(LINTLIBRARY)
    (port, mode)
	io_t port;
	int mode;
{ return tioctl_tiocext(port, mode); }
#else
(
	io_t port,
	int mode
);
#endif

/* Routine tioctl_tiocucntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocucntl
#if	defined(LINTLIBRARY)
    (port, set_or_clear)
	io_t port;
	int set_or_clear;
{ return tioctl_tiocucntl(port, set_or_clear); }
#else
(
	io_t port,
	int set_or_clear
);
#endif

/* Routine tioctl_tiocswinsz */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocswinsz
#if	defined(LINTLIBRARY)
    (port, sizes)
	io_t port;
	winsize_t sizes;
{ return tioctl_tiocswinsz(port, sizes); }
#else
(
	io_t port,
	winsize_t sizes
);
#endif

/* Routine tioctl_tiocgwinsz */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocgwinsz
#if	defined(LINTLIBRARY)
    (port, sizes)
	io_t port;
	winsize_t *sizes;
{ return tioctl_tiocgwinsz(port, sizes); }
#else
(
	io_t port,
	winsize_t *sizes
);
#endif

/* Routine tioctl_tiocremote */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocremote
#if	defined(LINTLIBRARY)
    (port, on_or_off)
	io_t port;
	int on_or_off;
{ return tioctl_tiocremote(port, on_or_off); }
#else
(
	io_t port,
	int on_or_off
);
#endif

/* Routine tioctl_tiocmget */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocmget
#if	defined(LINTLIBRARY)
    (port, bits)
	io_t port;
	int *bits;
{ return tioctl_tiocmget(port, bits); }
#else
(
	io_t port,
	int *bits
);
#endif

/* Routine tioctl_tiocmbic */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocmbic
#if	defined(LINTLIBRARY)
    (port, bits)
	io_t port;
	int bits;
{ return tioctl_tiocmbic(port, bits); }
#else
(
	io_t port,
	int bits
);
#endif

/* Routine tioctl_tiocmbis */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocmbis
#if	defined(LINTLIBRARY)
    (port, bits)
	io_t port;
	int bits;
{ return tioctl_tiocmbis(port, bits); }
#else
(
	io_t port,
	int bits
);
#endif

/* Routine tioctl_tiocmset */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocmset
#if	defined(LINTLIBRARY)
    (port, bits)
	io_t port;
	int bits;
{ return tioctl_tiocmset(port, bits); }
#else
(
	io_t port,
	int bits
);
#endif

/* Routine tioctl_tiocstart */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocstart
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return tioctl_tiocstart(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocstop */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocstop
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return tioctl_tiocstop(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocpkt */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocpkt
#if	defined(LINTLIBRARY)
    (port, on_or_off)
	io_t port;
	int on_or_off;
{ return tioctl_tiocpkt(port, on_or_off); }
#else
(
	io_t port,
	int on_or_off
);
#endif

/* Routine tioctl_tiocsti */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocsti
#if	defined(LINTLIBRARY)
    (port, datum)
	io_t port;
	char datum;
{ return tioctl_tiocsti(port, datum); }
#else
(
	io_t port,
	char datum
);
#endif

/* Routine tioctl_tiocoutq */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocoutq
#if	defined(LINTLIBRARY)
    (port, queue_size)
	io_t port;
	int *queue_size;
{ return tioctl_tiocoutq(port, queue_size); }
#else
(
	io_t port,
	int *queue_size
);
#endif

/* Routine tioctl_tiocspgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocspgrp
#if	defined(LINTLIBRARY)
    (port, pgrp)
	io_t port;
	int pgrp;
{ return tioctl_tiocspgrp(port, pgrp); }
#else
(
	io_t port,
	int pgrp
);
#endif

/* Routine tioctl_tiocgpgrp */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocgpgrp
#if	defined(LINTLIBRARY)
    (port, pgrp)
	io_t port;
	int *pgrp;
{ return tioctl_tiocgpgrp(port, pgrp); }
#else
(
	io_t port,
	int *pgrp
);
#endif

/* Routine tioctl_tioccdtr */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tioccdtr
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return tioctl_tioccdtr(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocsdtr */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocsdtr
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return tioctl_tiocsdtr(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tioccbrk */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tioccbrk
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return tioctl_tioccbrk(port); }
#else
(
	io_t port
);
#endif

/* Routine tioctl_tiocsbrk */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t tioctl_tiocsbrk
#if	defined(LINTLIBRARY)
    (port)
	io_t port;
{ return tioctl_tiocsbrk(port); }
#else
(
	io_t port
);
#endif

#endif	/* not defined(_tioctl_user_) */
