#ifndef	_io_user_
#define	_io_user_

/* Module io */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine io_write */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_write
#if	defined(LINTLIBRARY)
    (io_object, data, dataCnt, offset, amount)
	io_t io_object;
	data_t data;
	mach_msg_type_number_t dataCnt;
	off_t offset;
	mach_msg_type_number_t *amount;
{ return __io_write(io_object, data, dataCnt, offset, amount); }
#else
(
	io_t io_object,
	data_t data,
	mach_msg_type_number_t dataCnt,
	off_t offset,
	mach_msg_type_number_t *amount
);
#endif

/* Routine io_read */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_read
#if	defined(LINTLIBRARY)
    (io_object, data, dataCnt, offset, amount)
	io_t io_object;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
	off_t offset;
	mach_msg_type_number_t amount;
{ return __io_read(io_object, data, dataCnt, offset, amount); }
#else
(
	io_t io_object,
	data_t *data,
	mach_msg_type_number_t *dataCnt,
	off_t offset,
	mach_msg_type_number_t amount
);
#endif

/* Routine io_seek */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_seek
#if	defined(LINTLIBRARY)
    (io_object, offset, whence, newp)
	io_t io_object;
	off_t offset;
	int whence;
	off_t *newp;
{ return __io_seek(io_object, offset, whence, newp); }
#else
(
	io_t io_object,
	off_t offset,
	int whence,
	off_t *newp
);
#endif

/* Routine io_readable */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_readable
#if	defined(LINTLIBRARY)
    (io_object, amount)
	io_t io_object;
	mach_msg_type_number_t *amount;
{ return __io_readable(io_object, amount); }
#else
(
	io_t io_object,
	mach_msg_type_number_t *amount
);
#endif

/* Routine io_set_all_openmodes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_set_all_openmodes
#if	defined(LINTLIBRARY)
    (io_object, newbits)
	io_t io_object;
	int newbits;
{ return __io_set_all_openmodes(io_object, newbits); }
#else
(
	io_t io_object,
	int newbits
);
#endif

/* Routine io_get_openmodes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_get_openmodes
#if	defined(LINTLIBRARY)
    (io_object, bits)
	io_t io_object;
	int *bits;
{ return __io_get_openmodes(io_object, bits); }
#else
(
	io_t io_object,
	int *bits
);
#endif

/* Routine io_set_some_openmodes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_set_some_openmodes
#if	defined(LINTLIBRARY)
    (io_object, bits_to_set)
	io_t io_object;
	int bits_to_set;
{ return __io_set_some_openmodes(io_object, bits_to_set); }
#else
(
	io_t io_object,
	int bits_to_set
);
#endif

/* Routine io_clear_some_openmodes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_clear_some_openmodes
#if	defined(LINTLIBRARY)
    (io_object, bits_to_clear)
	io_t io_object;
	int bits_to_clear;
{ return __io_clear_some_openmodes(io_object, bits_to_clear); }
#else
(
	io_t io_object,
	int bits_to_clear
);
#endif

/* Routine io_async */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_async
#if	defined(LINTLIBRARY)
    (io_object, notify_port, notify_portPoly, async_id_port)
	io_t io_object;
	mach_port_t notify_port;
	mach_msg_type_name_t notify_portPoly;
	mach_port_t *async_id_port;
{ return __io_async(io_object, notify_port, notify_portPoly, async_id_port); }
#else
(
	io_t io_object,
	mach_port_t notify_port,
	mach_msg_type_name_t notify_portPoly,
	mach_port_t *async_id_port
);
#endif

/* Routine io_mod_owner */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_mod_owner
#if	defined(LINTLIBRARY)
    (io_object, owner)
	io_t io_object;
	pid_t owner;
{ return __io_mod_owner(io_object, owner); }
#else
(
	io_t io_object,
	pid_t owner
);
#endif

/* Routine io_get_owner */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_get_owner
#if	defined(LINTLIBRARY)
    (io_object, owner)
	io_t io_object;
	pid_t *owner;
{ return __io_get_owner(io_object, owner); }
#else
(
	io_t io_object,
	pid_t *owner
);
#endif

/* Routine io_get_icky_async_id */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_get_icky_async_id
#if	defined(LINTLIBRARY)
    (io_object, icky_async_id_port)
	io_t io_object;
	mach_port_t *icky_async_id_port;
{ return __io_get_icky_async_id(io_object, icky_async_id_port); }
#else
(
	io_t io_object,
	mach_port_t *icky_async_id_port
);
#endif

/* Routine io_select */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_select
#if	defined(LINTLIBRARY)
    (io_object, reply, timeout, select_type)
	io_t io_object;
	mach_port_t reply;
	natural_t timeout;
	int *select_type;
{ return __io_select(io_object, reply, timeout, select_type); }
#else
(
	io_t io_object,
	mach_port_t reply,
	natural_t timeout,
	int *select_type
);
#endif

/* Routine io_stat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_stat
#if	defined(LINTLIBRARY)
    (stat_object, stat_info)
	io_t stat_object;
	io_statbuf_t *stat_info;
{ return __io_stat(stat_object, stat_info); }
#else
(
	io_t stat_object,
	io_statbuf_t *stat_info
);
#endif

/* SimpleRoutine io_reauthenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_reauthenticate
#if	defined(LINTLIBRARY)
    (auth_object, rendezvous2, rendezvous2Poly)
	io_t auth_object;
	mach_port_t rendezvous2;
	mach_msg_type_name_t rendezvous2Poly;
{ return __io_reauthenticate(auth_object, rendezvous2, rendezvous2Poly); }
#else
(
	io_t auth_object,
	mach_port_t rendezvous2,
	mach_msg_type_name_t rendezvous2Poly
);
#endif

/* Routine io_restrict_auth */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_restrict_auth
#if	defined(LINTLIBRARY)
    (io_object, new_object, uids, uidsCnt, gids, gidsCnt)
	io_t io_object;
	mach_port_t *new_object;
	idarray_t uids;
	mach_msg_type_number_t uidsCnt;
	idarray_t gids;
	mach_msg_type_number_t gidsCnt;
{ return __io_restrict_auth(io_object, new_object, uids, uidsCnt, gids, gidsCnt); }
#else
(
	io_t io_object,
	mach_port_t *new_object,
	idarray_t uids,
	mach_msg_type_number_t uidsCnt,
	idarray_t gids,
	mach_msg_type_number_t gidsCnt
);
#endif

/* Routine io_duplicate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_duplicate
#if	defined(LINTLIBRARY)
    (io_object, newport)
	io_t io_object;
	mach_port_t *newport;
{ return __io_duplicate(io_object, newport); }
#else
(
	io_t io_object,
	mach_port_t *newport
);
#endif

/* Routine io_server_version */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_server_version
#if	defined(LINTLIBRARY)
    (vers_object, server_name, server_major_version, server_minor_version, server_edit_level)
	io_t vers_object;
	string_t server_name;
	int *server_major_version;
	int *server_minor_version;
	int *server_edit_level;
{ return __io_server_version(vers_object, server_name, server_major_version, server_minor_version, server_edit_level); }
#else
(
	io_t vers_object,
	string_t server_name,
	int *server_major_version,
	int *server_minor_version,
	int *server_edit_level
);
#endif

/* Routine io_map */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_map
#if	defined(LINTLIBRARY)
    (io_object, memobjrd, memobjwt)
	io_t io_object;
	mach_port_t *memobjrd;
	mach_port_t *memobjwt;
{ return __io_map(io_object, memobjrd, memobjwt); }
#else
(
	io_t io_object,
	mach_port_t *memobjrd,
	mach_port_t *memobjwt
);
#endif

/* Routine io_map_cntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_map_cntl
#if	defined(LINTLIBRARY)
    (io_object, memobj)
	io_t io_object;
	mach_port_t *memobj;
{ return __io_map_cntl(io_object, memobj); }
#else
(
	io_t io_object,
	mach_port_t *memobj
);
#endif

/* Routine io_get_conch */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_get_conch
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return __io_get_conch(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_release_conch */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_release_conch
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return __io_release_conch(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_eofnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_eofnotify
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return __io_eofnotify(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_prenotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_prenotify
#if	defined(LINTLIBRARY)
    (io_object, write_start, write_end)
	io_t io_object;
	vm_offset_t write_start;
	vm_offset_t write_end;
{ return __io_prenotify(io_object, write_start, write_end); }
#else
(
	io_t io_object,
	vm_offset_t write_start,
	vm_offset_t write_end
);
#endif

/* Routine io_postnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_postnotify
#if	defined(LINTLIBRARY)
    (io_object, write_start, write_end)
	io_t io_object;
	vm_offset_t write_start;
	vm_offset_t write_end;
{ return __io_postnotify(io_object, write_start, write_end); }
#else
(
	io_t io_object,
	vm_offset_t write_start,
	vm_offset_t write_end
);
#endif

/* Routine io_readnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_readnotify
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return __io_readnotify(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_readsleep */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_readsleep
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return __io_readsleep(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_sigio */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_sigio
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return __io_sigio(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_pathconf */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_pathconf
#if	defined(LINTLIBRARY)
    (io_object, name, value)
	io_t io_object;
	int name;
	int *value;
{ return __io_pathconf(io_object, name, value); }
#else
(
	io_t io_object,
	int name,
	int *value
);
#endif

/* Routine io_identity */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __io_identity
#if	defined(LINTLIBRARY)
    (io_object, idport, fsidport, fileno)
	io_t io_object;
	mach_port_t *idport;
	mach_port_t *fsidport;
	int *fileno;
{ return __io_identity(io_object, idport, fsidport, fileno); }
#else
(
	io_t io_object,
	mach_port_t *idport,
	mach_port_t *fsidport,
	int *fileno
);
#endif


/* Module io */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine io_write */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_write
#if	defined(LINTLIBRARY)
    (io_object, data, dataCnt, offset, amount)
	io_t io_object;
	data_t data;
	mach_msg_type_number_t dataCnt;
	off_t offset;
	mach_msg_type_number_t *amount;
{ return io_write(io_object, data, dataCnt, offset, amount); }
#else
(
	io_t io_object,
	data_t data,
	mach_msg_type_number_t dataCnt,
	off_t offset,
	mach_msg_type_number_t *amount
);
#endif

/* Routine io_read */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_read
#if	defined(LINTLIBRARY)
    (io_object, data, dataCnt, offset, amount)
	io_t io_object;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
	off_t offset;
	mach_msg_type_number_t amount;
{ return io_read(io_object, data, dataCnt, offset, amount); }
#else
(
	io_t io_object,
	data_t *data,
	mach_msg_type_number_t *dataCnt,
	off_t offset,
	mach_msg_type_number_t amount
);
#endif

/* Routine io_seek */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_seek
#if	defined(LINTLIBRARY)
    (io_object, offset, whence, newp)
	io_t io_object;
	off_t offset;
	int whence;
	off_t *newp;
{ return io_seek(io_object, offset, whence, newp); }
#else
(
	io_t io_object,
	off_t offset,
	int whence,
	off_t *newp
);
#endif

/* Routine io_readable */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_readable
#if	defined(LINTLIBRARY)
    (io_object, amount)
	io_t io_object;
	mach_msg_type_number_t *amount;
{ return io_readable(io_object, amount); }
#else
(
	io_t io_object,
	mach_msg_type_number_t *amount
);
#endif

/* Routine io_set_all_openmodes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_set_all_openmodes
#if	defined(LINTLIBRARY)
    (io_object, newbits)
	io_t io_object;
	int newbits;
{ return io_set_all_openmodes(io_object, newbits); }
#else
(
	io_t io_object,
	int newbits
);
#endif

/* Routine io_get_openmodes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_openmodes
#if	defined(LINTLIBRARY)
    (io_object, bits)
	io_t io_object;
	int *bits;
{ return io_get_openmodes(io_object, bits); }
#else
(
	io_t io_object,
	int *bits
);
#endif

/* Routine io_set_some_openmodes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_set_some_openmodes
#if	defined(LINTLIBRARY)
    (io_object, bits_to_set)
	io_t io_object;
	int bits_to_set;
{ return io_set_some_openmodes(io_object, bits_to_set); }
#else
(
	io_t io_object,
	int bits_to_set
);
#endif

/* Routine io_clear_some_openmodes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_clear_some_openmodes
#if	defined(LINTLIBRARY)
    (io_object, bits_to_clear)
	io_t io_object;
	int bits_to_clear;
{ return io_clear_some_openmodes(io_object, bits_to_clear); }
#else
(
	io_t io_object,
	int bits_to_clear
);
#endif

/* Routine io_async */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_async
#if	defined(LINTLIBRARY)
    (io_object, notify_port, notify_portPoly, async_id_port)
	io_t io_object;
	mach_port_t notify_port;
	mach_msg_type_name_t notify_portPoly;
	mach_port_t *async_id_port;
{ return io_async(io_object, notify_port, notify_portPoly, async_id_port); }
#else
(
	io_t io_object,
	mach_port_t notify_port,
	mach_msg_type_name_t notify_portPoly,
	mach_port_t *async_id_port
);
#endif

/* Routine io_mod_owner */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_mod_owner
#if	defined(LINTLIBRARY)
    (io_object, owner)
	io_t io_object;
	pid_t owner;
{ return io_mod_owner(io_object, owner); }
#else
(
	io_t io_object,
	pid_t owner
);
#endif

/* Routine io_get_owner */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_owner
#if	defined(LINTLIBRARY)
    (io_object, owner)
	io_t io_object;
	pid_t *owner;
{ return io_get_owner(io_object, owner); }
#else
(
	io_t io_object,
	pid_t *owner
);
#endif

/* Routine io_get_icky_async_id */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_icky_async_id
#if	defined(LINTLIBRARY)
    (io_object, icky_async_id_port)
	io_t io_object;
	mach_port_t *icky_async_id_port;
{ return io_get_icky_async_id(io_object, icky_async_id_port); }
#else
(
	io_t io_object,
	mach_port_t *icky_async_id_port
);
#endif

/* Routine io_select */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_select
#if	defined(LINTLIBRARY)
    (io_object, reply, timeout, select_type)
	io_t io_object;
	mach_port_t reply;
	natural_t timeout;
	int *select_type;
{ return io_select(io_object, reply, timeout, select_type); }
#else
(
	io_t io_object,
	mach_port_t reply,
	natural_t timeout,
	int *select_type
);
#endif

/* Routine io_stat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_stat
#if	defined(LINTLIBRARY)
    (stat_object, stat_info)
	io_t stat_object;
	io_statbuf_t *stat_info;
{ return io_stat(stat_object, stat_info); }
#else
(
	io_t stat_object,
	io_statbuf_t *stat_info
);
#endif

/* SimpleRoutine io_reauthenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_reauthenticate
#if	defined(LINTLIBRARY)
    (auth_object, rendezvous2, rendezvous2Poly)
	io_t auth_object;
	mach_port_t rendezvous2;
	mach_msg_type_name_t rendezvous2Poly;
{ return io_reauthenticate(auth_object, rendezvous2, rendezvous2Poly); }
#else
(
	io_t auth_object,
	mach_port_t rendezvous2,
	mach_msg_type_name_t rendezvous2Poly
);
#endif

/* Routine io_restrict_auth */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_restrict_auth
#if	defined(LINTLIBRARY)
    (io_object, new_object, uids, uidsCnt, gids, gidsCnt)
	io_t io_object;
	mach_port_t *new_object;
	idarray_t uids;
	mach_msg_type_number_t uidsCnt;
	idarray_t gids;
	mach_msg_type_number_t gidsCnt;
{ return io_restrict_auth(io_object, new_object, uids, uidsCnt, gids, gidsCnt); }
#else
(
	io_t io_object,
	mach_port_t *new_object,
	idarray_t uids,
	mach_msg_type_number_t uidsCnt,
	idarray_t gids,
	mach_msg_type_number_t gidsCnt
);
#endif

/* Routine io_duplicate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_duplicate
#if	defined(LINTLIBRARY)
    (io_object, newport)
	io_t io_object;
	mach_port_t *newport;
{ return io_duplicate(io_object, newport); }
#else
(
	io_t io_object,
	mach_port_t *newport
);
#endif

/* Routine io_server_version */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_server_version
#if	defined(LINTLIBRARY)
    (vers_object, server_name, server_major_version, server_minor_version, server_edit_level)
	io_t vers_object;
	string_t server_name;
	int *server_major_version;
	int *server_minor_version;
	int *server_edit_level;
{ return io_server_version(vers_object, server_name, server_major_version, server_minor_version, server_edit_level); }
#else
(
	io_t vers_object,
	string_t server_name,
	int *server_major_version,
	int *server_minor_version,
	int *server_edit_level
);
#endif

/* Routine io_map */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_map
#if	defined(LINTLIBRARY)
    (io_object, memobjrd, memobjwt)
	io_t io_object;
	mach_port_t *memobjrd;
	mach_port_t *memobjwt;
{ return io_map(io_object, memobjrd, memobjwt); }
#else
(
	io_t io_object,
	mach_port_t *memobjrd,
	mach_port_t *memobjwt
);
#endif

/* Routine io_map_cntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_map_cntl
#if	defined(LINTLIBRARY)
    (io_object, memobj)
	io_t io_object;
	mach_port_t *memobj;
{ return io_map_cntl(io_object, memobj); }
#else
(
	io_t io_object,
	mach_port_t *memobj
);
#endif

/* Routine io_get_conch */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_get_conch
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return io_get_conch(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_release_conch */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_release_conch
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return io_release_conch(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_eofnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_eofnotify
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return io_eofnotify(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_prenotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_prenotify
#if	defined(LINTLIBRARY)
    (io_object, write_start, write_end)
	io_t io_object;
	vm_offset_t write_start;
	vm_offset_t write_end;
{ return io_prenotify(io_object, write_start, write_end); }
#else
(
	io_t io_object,
	vm_offset_t write_start,
	vm_offset_t write_end
);
#endif

/* Routine io_postnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_postnotify
#if	defined(LINTLIBRARY)
    (io_object, write_start, write_end)
	io_t io_object;
	vm_offset_t write_start;
	vm_offset_t write_end;
{ return io_postnotify(io_object, write_start, write_end); }
#else
(
	io_t io_object,
	vm_offset_t write_start,
	vm_offset_t write_end
);
#endif

/* Routine io_readnotify */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_readnotify
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return io_readnotify(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_readsleep */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_readsleep
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return io_readsleep(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_sigio */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_sigio
#if	defined(LINTLIBRARY)
    (io_object)
	io_t io_object;
{ return io_sigio(io_object); }
#else
(
	io_t io_object
);
#endif

/* Routine io_pathconf */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_pathconf
#if	defined(LINTLIBRARY)
    (io_object, name, value)
	io_t io_object;
	int name;
	int *value;
{ return io_pathconf(io_object, name, value); }
#else
(
	io_t io_object,
	int name,
	int *value
);
#endif

/* Routine io_identity */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t io_identity
#if	defined(LINTLIBRARY)
    (io_object, idport, fsidport, fileno)
	io_t io_object;
	mach_port_t *idport;
	mach_port_t *fsidport;
	int *fileno;
{ return io_identity(io_object, idport, fsidport, fileno); }
#else
(
	io_t io_object,
	mach_port_t *idport,
	mach_port_t *fsidport,
	int *fileno
);
#endif

#endif	/* not defined(_io_user_) */
