#ifndef	_fs_user_
#define	_fs_user_

/* Module fs */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine file_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_exec
#if	defined(LINTLIBRARY)
    (exec_file, exec_task, flags, argv, argvCnt, envp, envpCnt, fdarray, fdarrayPoly, fdarrayCnt, portarray, portarrayPoly, portarrayCnt, intarray, intarrayCnt, deallocnames, deallocnamesCnt, destroynames, destroynamesCnt)
	file_t exec_file;
	mach_port_t exec_task;
	int flags;
	data_t argv;
	mach_msg_type_number_t argvCnt;
	data_t envp;
	mach_msg_type_number_t envpCnt;
	portarray_t fdarray;
	mach_msg_type_name_t fdarrayPoly;
	mach_msg_type_number_t fdarrayCnt;
	portarray_t portarray;
	mach_msg_type_name_t portarrayPoly;
	mach_msg_type_number_t portarrayCnt;
	intarray_t intarray;
	mach_msg_type_number_t intarrayCnt;
	mach_port_array_t deallocnames;
	mach_msg_type_number_t deallocnamesCnt;
	mach_port_array_t destroynames;
	mach_msg_type_number_t destroynamesCnt;
{ return __file_exec(exec_file, exec_task, flags, argv, argvCnt, envp, envpCnt, fdarray, fdarrayPoly, fdarrayCnt, portarray, portarrayPoly, portarrayCnt, intarray, intarrayCnt, deallocnames, deallocnamesCnt, destroynames, destroynamesCnt); }
#else
(
	file_t exec_file,
	mach_port_t exec_task,
	int flags,
	data_t argv,
	mach_msg_type_number_t argvCnt,
	data_t envp,
	mach_msg_type_number_t envpCnt,
	portarray_t fdarray,
	mach_msg_type_name_t fdarrayPoly,
	mach_msg_type_number_t fdarrayCnt,
	portarray_t portarray,
	mach_msg_type_name_t portarrayPoly,
	mach_msg_type_number_t portarrayCnt,
	intarray_t intarray,
	mach_msg_type_number_t intarrayCnt,
	mach_port_array_t deallocnames,
	mach_msg_type_number_t deallocnamesCnt,
	mach_port_array_t destroynames,
	mach_msg_type_number_t destroynamesCnt
);
#endif

/* Routine file_chown */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_chown
#if	defined(LINTLIBRARY)
    (chown_file, new_owner, new_group)
	file_t chown_file;
	uid_t new_owner;
	gid_t new_group;
{ return __file_chown(chown_file, new_owner, new_group); }
#else
(
	file_t chown_file,
	uid_t new_owner,
	gid_t new_group
);
#endif

/* Routine file_chauthor */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_chauthor
#if	defined(LINTLIBRARY)
    (chauth_file, new_author)
	file_t chauth_file;
	uid_t new_author;
{ return __file_chauthor(chauth_file, new_author); }
#else
(
	file_t chauth_file,
	uid_t new_author
);
#endif

/* Routine file_chmod */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_chmod
#if	defined(LINTLIBRARY)
    (chmod_file, new_mode)
	file_t chmod_file;
	mode_t new_mode;
{ return __file_chmod(chmod_file, new_mode); }
#else
(
	file_t chmod_file,
	mode_t new_mode
);
#endif

/* Routine file_chflags */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_chflags
#if	defined(LINTLIBRARY)
    (chflags_file, new_flags)
	file_t chflags_file;
	int new_flags;
{ return __file_chflags(chflags_file, new_flags); }
#else
(
	file_t chflags_file,
	int new_flags
);
#endif

/* Routine file_utimes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_utimes
#if	defined(LINTLIBRARY)
    (utimes_file, new_atime, new_mtime)
	file_t utimes_file;
	time_value_t new_atime;
	time_value_t new_mtime;
{ return __file_utimes(utimes_file, new_atime, new_mtime); }
#else
(
	file_t utimes_file,
	time_value_t new_atime,
	time_value_t new_mtime
);
#endif

/* Routine file_set_size */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_set_size
#if	defined(LINTLIBRARY)
    (trunc_file, new_size)
	file_t trunc_file;
	off_t new_size;
{ return __file_set_size(trunc_file, new_size); }
#else
(
	file_t trunc_file,
	off_t new_size
);
#endif

/* Routine file_lock */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_lock
#if	defined(LINTLIBRARY)
    (lock_file, flags)
	file_t lock_file;
	int flags;
{ return __file_lock(lock_file, flags); }
#else
(
	file_t lock_file,
	int flags
);
#endif

/* Routine file_lock_stat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_lock_stat
#if	defined(LINTLIBRARY)
    (lock_file, mystatus, otherstatus)
	file_t lock_file;
	int *mystatus;
	int *otherstatus;
{ return __file_lock_stat(lock_file, mystatus, otherstatus); }
#else
(
	file_t lock_file,
	int *mystatus,
	int *otherstatus
);
#endif

/* Routine file_check_access */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_check_access
#if	defined(LINTLIBRARY)
    (file, allowed)
	file_t file;
	int *allowed;
{ return __file_check_access(file, allowed); }
#else
(
	file_t file,
	int *allowed
);
#endif

/* Routine file_notice_changes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_notice_changes
#if	defined(LINTLIBRARY)
    (file, port, portPoly)
	file_t file;
	mach_port_t port;
	mach_msg_type_name_t portPoly;
{ return __file_notice_changes(file, port, portPoly); }
#else
(
	file_t file,
	mach_port_t port,
	mach_msg_type_name_t portPoly
);
#endif

/* Routine file_getcontrol */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_getcontrol
#if	defined(LINTLIBRARY)
    (file, control)
	file_t file;
	mach_port_t *control;
{ return __file_getcontrol(file, control); }
#else
(
	file_t file,
	mach_port_t *control
);
#endif

/* Routine file_statfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_statfs
#if	defined(LINTLIBRARY)
    (file, info)
	file_t file;
	fsys_statfsbuf_t *info;
{ return __file_statfs(file, info); }
#else
(
	file_t file,
	fsys_statfsbuf_t *info
);
#endif

/* Routine file_sync */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_sync
#if	defined(LINTLIBRARY)
    (file, wait, omit_metadata)
	file_t file;
	int wait;
	int omit_metadata;
{ return __file_sync(file, wait, omit_metadata); }
#else
(
	file_t file,
	int wait,
	int omit_metadata
);
#endif

/* Routine file_syncfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_syncfs
#if	defined(LINTLIBRARY)
    (file, wait, do_children)
	file_t file;
	int wait;
	int do_children;
{ return __file_syncfs(file, wait, do_children); }
#else
(
	file_t file,
	int wait,
	int do_children
);
#endif

/* Routine file_get_storage_info */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_get_storage_info
#if	defined(LINTLIBRARY)
    (file, ports, portsCnt, ints, intsCnt, offsets, offsetsCnt, data, dataCnt)
	file_t file;
	portarray_t *ports;
	mach_msg_type_number_t *portsCnt;
	intarray_t *ints;
	mach_msg_type_number_t *intsCnt;
	off_array_t *offsets;
	mach_msg_type_number_t *offsetsCnt;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
{ return __file_get_storage_info(file, ports, portsCnt, ints, intsCnt, offsets, offsetsCnt, data, dataCnt); }
#else
(
	file_t file,
	portarray_t *ports,
	mach_msg_type_number_t *portsCnt,
	intarray_t *ints,
	mach_msg_type_number_t *intsCnt,
	off_array_t *offsets,
	mach_msg_type_number_t *offsetsCnt,
	data_t *data,
	mach_msg_type_number_t *dataCnt
);
#endif

/* Routine file_getlinknode */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_getlinknode
#if	defined(LINTLIBRARY)
    (file, linknode)
	file_t file;
	mach_port_t *linknode;
{ return __file_getlinknode(file, linknode); }
#else
(
	file_t file,
	mach_port_t *linknode
);
#endif

/* Routine file_getfh */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_getfh
#if	defined(LINTLIBRARY)
    (file, filehandle, filehandleCnt)
	file_t file;
	data_t *filehandle;
	mach_msg_type_number_t *filehandleCnt;
{ return __file_getfh(file, filehandle, filehandleCnt); }
#else
(
	file_t file,
	data_t *filehandle,
	mach_msg_type_number_t *filehandleCnt
);
#endif

/* Routine dir_lookup */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __dir_lookup
#if	defined(LINTLIBRARY)
    (start_dir, file_name, flags, mode, do_retry, retry_name, result)
	file_t start_dir;
	string_t file_name;
	int flags;
	mode_t mode;
	retry_type *do_retry;
	string_t retry_name;
	mach_port_t *result;
{ return __dir_lookup(start_dir, file_name, flags, mode, do_retry, retry_name, result); }
#else
(
	file_t start_dir,
	string_t file_name,
	int flags,
	mode_t mode,
	retry_type *do_retry,
	string_t retry_name,
	mach_port_t *result
);
#endif

/* Routine dir_readdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __dir_readdir
#if	defined(LINTLIBRARY)
    (dir, data, dataCnt, entry, nentries, bufsiz, amount)
	file_t dir;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
	int entry;
	int nentries;
	vm_size_t bufsiz;
	int *amount;
{ return __dir_readdir(dir, data, dataCnt, entry, nentries, bufsiz, amount); }
#else
(
	file_t dir,
	data_t *data,
	mach_msg_type_number_t *dataCnt,
	int entry,
	int nentries,
	vm_size_t bufsiz,
	int *amount
);
#endif

/* Routine dir_mkdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __dir_mkdir
#if	defined(LINTLIBRARY)
    (directory, name, mode)
	file_t directory;
	string_t name;
	mode_t mode;
{ return __dir_mkdir(directory, name, mode); }
#else
(
	file_t directory,
	string_t name,
	mode_t mode
);
#endif

/* Routine dir_rmdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __dir_rmdir
#if	defined(LINTLIBRARY)
    (directory, name)
	file_t directory;
	string_t name;
{ return __dir_rmdir(directory, name); }
#else
(
	file_t directory,
	string_t name
);
#endif

/* Routine dir_unlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __dir_unlink
#if	defined(LINTLIBRARY)
    (directory, name)
	file_t directory;
	string_t name;
{ return __dir_unlink(directory, name); }
#else
(
	file_t directory,
	string_t name
);
#endif

/* Routine dir_link */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __dir_link
#if	defined(LINTLIBRARY)
    (dir, file, name, excl)
	file_t dir;
	file_t file;
	string_t name;
	int excl;
{ return __dir_link(dir, file, name, excl); }
#else
(
	file_t dir,
	file_t file,
	string_t name,
	int excl
);
#endif

/* Routine dir_rename */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __dir_rename
#if	defined(LINTLIBRARY)
    (olddirectory, oldname, newdirectory, newname, excl)
	file_t olddirectory;
	string_t oldname;
	file_t newdirectory;
	string_t newname;
	int excl;
{ return __dir_rename(olddirectory, oldname, newdirectory, newname, excl); }
#else
(
	file_t olddirectory,
	string_t oldname,
	file_t newdirectory,
	string_t newname,
	int excl
);
#endif

/* Routine dir_mkfile */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __dir_mkfile
#if	defined(LINTLIBRARY)
    (directory, flags, mode, newnode)
	file_t directory;
	int flags;
	mode_t mode;
	mach_port_t *newnode;
{ return __dir_mkfile(directory, flags, mode, newnode); }
#else
(
	file_t directory,
	int flags,
	mode_t mode,
	mach_port_t *newnode
);
#endif

/* Routine dir_notice_changes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __dir_notice_changes
#if	defined(LINTLIBRARY)
    (directory, port, portPoly)
	file_t directory;
	mach_port_t port;
	mach_msg_type_name_t portPoly;
{ return __dir_notice_changes(directory, port, portPoly); }
#else
(
	file_t directory,
	mach_port_t port,
	mach_msg_type_name_t portPoly
);
#endif

/* Routine file_set_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_set_translator
#if	defined(LINTLIBRARY)
    (file, passive_flags, active_flags, oldtrans_flags, passive, passiveCnt, active, activePoly)
	file_t file;
	int passive_flags;
	int active_flags;
	int oldtrans_flags;
	data_t passive;
	mach_msg_type_number_t passiveCnt;
	mach_port_t active;
	mach_msg_type_name_t activePoly;
{ return __file_set_translator(file, passive_flags, active_flags, oldtrans_flags, passive, passiveCnt, active, activePoly); }
#else
(
	file_t file,
	int passive_flags,
	int active_flags,
	int oldtrans_flags,
	data_t passive,
	mach_msg_type_number_t passiveCnt,
	mach_port_t active,
	mach_msg_type_name_t activePoly
);
#endif

/* Routine file_get_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_get_translator
#if	defined(LINTLIBRARY)
    (file, translator, translatorCnt)
	file_t file;
	data_t *translator;
	mach_msg_type_number_t *translatorCnt;
{ return __file_get_translator(file, translator, translatorCnt); }
#else
(
	file_t file,
	data_t *translator,
	mach_msg_type_number_t *translatorCnt
);
#endif

/* Routine file_get_translator_cntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_get_translator_cntl
#if	defined(LINTLIBRARY)
    (file, translator_cntl)
	file_t file;
	mach_port_t *translator_cntl;
{ return __file_get_translator_cntl(file, translator_cntl); }
#else
(
	file_t file,
	mach_port_t *translator_cntl
);
#endif

/* Routine file_get_fs_options */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_get_fs_options
#if	defined(LINTLIBRARY)
    (file, options, optionsCnt)
	file_t file;
	data_t *options;
	mach_msg_type_number_t *optionsCnt;
{ return __file_get_fs_options(file, options, optionsCnt); }
#else
(
	file_t file,
	data_t *options,
	mach_msg_type_number_t *optionsCnt
);
#endif

/* Routine file_reparent */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __file_reparent
#if	defined(LINTLIBRARY)
    (file, parent, new_file)
	file_t file;
	mach_port_t parent;
	mach_port_t *new_file;
{ return __file_reparent(file, parent, new_file); }
#else
(
	file_t file,
	mach_port_t parent,
	mach_port_t *new_file
);
#endif


/* Module fs */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine file_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_exec
#if	defined(LINTLIBRARY)
    (exec_file, exec_task, flags, argv, argvCnt, envp, envpCnt, fdarray, fdarrayPoly, fdarrayCnt, portarray, portarrayPoly, portarrayCnt, intarray, intarrayCnt, deallocnames, deallocnamesCnt, destroynames, destroynamesCnt)
	file_t exec_file;
	mach_port_t exec_task;
	int flags;
	data_t argv;
	mach_msg_type_number_t argvCnt;
	data_t envp;
	mach_msg_type_number_t envpCnt;
	portarray_t fdarray;
	mach_msg_type_name_t fdarrayPoly;
	mach_msg_type_number_t fdarrayCnt;
	portarray_t portarray;
	mach_msg_type_name_t portarrayPoly;
	mach_msg_type_number_t portarrayCnt;
	intarray_t intarray;
	mach_msg_type_number_t intarrayCnt;
	mach_port_array_t deallocnames;
	mach_msg_type_number_t deallocnamesCnt;
	mach_port_array_t destroynames;
	mach_msg_type_number_t destroynamesCnt;
{ return file_exec(exec_file, exec_task, flags, argv, argvCnt, envp, envpCnt, fdarray, fdarrayPoly, fdarrayCnt, portarray, portarrayPoly, portarrayCnt, intarray, intarrayCnt, deallocnames, deallocnamesCnt, destroynames, destroynamesCnt); }
#else
(
	file_t exec_file,
	mach_port_t exec_task,
	int flags,
	data_t argv,
	mach_msg_type_number_t argvCnt,
	data_t envp,
	mach_msg_type_number_t envpCnt,
	portarray_t fdarray,
	mach_msg_type_name_t fdarrayPoly,
	mach_msg_type_number_t fdarrayCnt,
	portarray_t portarray,
	mach_msg_type_name_t portarrayPoly,
	mach_msg_type_number_t portarrayCnt,
	intarray_t intarray,
	mach_msg_type_number_t intarrayCnt,
	mach_port_array_t deallocnames,
	mach_msg_type_number_t deallocnamesCnt,
	mach_port_array_t destroynames,
	mach_msg_type_number_t destroynamesCnt
);
#endif

/* Routine file_chown */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_chown
#if	defined(LINTLIBRARY)
    (chown_file, new_owner, new_group)
	file_t chown_file;
	uid_t new_owner;
	gid_t new_group;
{ return file_chown(chown_file, new_owner, new_group); }
#else
(
	file_t chown_file,
	uid_t new_owner,
	gid_t new_group
);
#endif

/* Routine file_chauthor */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_chauthor
#if	defined(LINTLIBRARY)
    (chauth_file, new_author)
	file_t chauth_file;
	uid_t new_author;
{ return file_chauthor(chauth_file, new_author); }
#else
(
	file_t chauth_file,
	uid_t new_author
);
#endif

/* Routine file_chmod */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_chmod
#if	defined(LINTLIBRARY)
    (chmod_file, new_mode)
	file_t chmod_file;
	mode_t new_mode;
{ return file_chmod(chmod_file, new_mode); }
#else
(
	file_t chmod_file,
	mode_t new_mode
);
#endif

/* Routine file_chflags */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_chflags
#if	defined(LINTLIBRARY)
    (chflags_file, new_flags)
	file_t chflags_file;
	int new_flags;
{ return file_chflags(chflags_file, new_flags); }
#else
(
	file_t chflags_file,
	int new_flags
);
#endif

/* Routine file_utimes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_utimes
#if	defined(LINTLIBRARY)
    (utimes_file, new_atime, new_mtime)
	file_t utimes_file;
	time_value_t new_atime;
	time_value_t new_mtime;
{ return file_utimes(utimes_file, new_atime, new_mtime); }
#else
(
	file_t utimes_file,
	time_value_t new_atime,
	time_value_t new_mtime
);
#endif

/* Routine file_set_size */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_set_size
#if	defined(LINTLIBRARY)
    (trunc_file, new_size)
	file_t trunc_file;
	off_t new_size;
{ return file_set_size(trunc_file, new_size); }
#else
(
	file_t trunc_file,
	off_t new_size
);
#endif

/* Routine file_lock */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_lock
#if	defined(LINTLIBRARY)
    (lock_file, flags)
	file_t lock_file;
	int flags;
{ return file_lock(lock_file, flags); }
#else
(
	file_t lock_file,
	int flags
);
#endif

/* Routine file_lock_stat */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_lock_stat
#if	defined(LINTLIBRARY)
    (lock_file, mystatus, otherstatus)
	file_t lock_file;
	int *mystatus;
	int *otherstatus;
{ return file_lock_stat(lock_file, mystatus, otherstatus); }
#else
(
	file_t lock_file,
	int *mystatus,
	int *otherstatus
);
#endif

/* Routine file_check_access */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_check_access
#if	defined(LINTLIBRARY)
    (file, allowed)
	file_t file;
	int *allowed;
{ return file_check_access(file, allowed); }
#else
(
	file_t file,
	int *allowed
);
#endif

/* Routine file_notice_changes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_notice_changes
#if	defined(LINTLIBRARY)
    (file, port, portPoly)
	file_t file;
	mach_port_t port;
	mach_msg_type_name_t portPoly;
{ return file_notice_changes(file, port, portPoly); }
#else
(
	file_t file,
	mach_port_t port,
	mach_msg_type_name_t portPoly
);
#endif

/* Routine file_getcontrol */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_getcontrol
#if	defined(LINTLIBRARY)
    (file, control)
	file_t file;
	mach_port_t *control;
{ return file_getcontrol(file, control); }
#else
(
	file_t file,
	mach_port_t *control
);
#endif

/* Routine file_statfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_statfs
#if	defined(LINTLIBRARY)
    (file, info)
	file_t file;
	fsys_statfsbuf_t *info;
{ return file_statfs(file, info); }
#else
(
	file_t file,
	fsys_statfsbuf_t *info
);
#endif

/* Routine file_sync */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_sync
#if	defined(LINTLIBRARY)
    (file, wait, omit_metadata)
	file_t file;
	int wait;
	int omit_metadata;
{ return file_sync(file, wait, omit_metadata); }
#else
(
	file_t file,
	int wait,
	int omit_metadata
);
#endif

/* Routine file_syncfs */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_syncfs
#if	defined(LINTLIBRARY)
    (file, wait, do_children)
	file_t file;
	int wait;
	int do_children;
{ return file_syncfs(file, wait, do_children); }
#else
(
	file_t file,
	int wait,
	int do_children
);
#endif

/* Routine file_get_storage_info */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_get_storage_info
#if	defined(LINTLIBRARY)
    (file, ports, portsCnt, ints, intsCnt, offsets, offsetsCnt, data, dataCnt)
	file_t file;
	portarray_t *ports;
	mach_msg_type_number_t *portsCnt;
	intarray_t *ints;
	mach_msg_type_number_t *intsCnt;
	off_array_t *offsets;
	mach_msg_type_number_t *offsetsCnt;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
{ return file_get_storage_info(file, ports, portsCnt, ints, intsCnt, offsets, offsetsCnt, data, dataCnt); }
#else
(
	file_t file,
	portarray_t *ports,
	mach_msg_type_number_t *portsCnt,
	intarray_t *ints,
	mach_msg_type_number_t *intsCnt,
	off_array_t *offsets,
	mach_msg_type_number_t *offsetsCnt,
	data_t *data,
	mach_msg_type_number_t *dataCnt
);
#endif

/* Routine file_getlinknode */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_getlinknode
#if	defined(LINTLIBRARY)
    (file, linknode)
	file_t file;
	mach_port_t *linknode;
{ return file_getlinknode(file, linknode); }
#else
(
	file_t file,
	mach_port_t *linknode
);
#endif

/* Routine file_getfh */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_getfh
#if	defined(LINTLIBRARY)
    (file, filehandle, filehandleCnt)
	file_t file;
	data_t *filehandle;
	mach_msg_type_number_t *filehandleCnt;
{ return file_getfh(file, filehandle, filehandleCnt); }
#else
(
	file_t file,
	data_t *filehandle,
	mach_msg_type_number_t *filehandleCnt
);
#endif

/* Routine dir_lookup */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_lookup
#if	defined(LINTLIBRARY)
    (start_dir, file_name, flags, mode, do_retry, retry_name, result)
	file_t start_dir;
	string_t file_name;
	int flags;
	mode_t mode;
	retry_type *do_retry;
	string_t retry_name;
	mach_port_t *result;
{ return dir_lookup(start_dir, file_name, flags, mode, do_retry, retry_name, result); }
#else
(
	file_t start_dir,
	string_t file_name,
	int flags,
	mode_t mode,
	retry_type *do_retry,
	string_t retry_name,
	mach_port_t *result
);
#endif

/* Routine dir_readdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_readdir
#if	defined(LINTLIBRARY)
    (dir, data, dataCnt, entry, nentries, bufsiz, amount)
	file_t dir;
	data_t *data;
	mach_msg_type_number_t *dataCnt;
	int entry;
	int nentries;
	vm_size_t bufsiz;
	int *amount;
{ return dir_readdir(dir, data, dataCnt, entry, nentries, bufsiz, amount); }
#else
(
	file_t dir,
	data_t *data,
	mach_msg_type_number_t *dataCnt,
	int entry,
	int nentries,
	vm_size_t bufsiz,
	int *amount
);
#endif

/* Routine dir_mkdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_mkdir
#if	defined(LINTLIBRARY)
    (directory, name, mode)
	file_t directory;
	string_t name;
	mode_t mode;
{ return dir_mkdir(directory, name, mode); }
#else
(
	file_t directory,
	string_t name,
	mode_t mode
);
#endif

/* Routine dir_rmdir */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_rmdir
#if	defined(LINTLIBRARY)
    (directory, name)
	file_t directory;
	string_t name;
{ return dir_rmdir(directory, name); }
#else
(
	file_t directory,
	string_t name
);
#endif

/* Routine dir_unlink */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_unlink
#if	defined(LINTLIBRARY)
    (directory, name)
	file_t directory;
	string_t name;
{ return dir_unlink(directory, name); }
#else
(
	file_t directory,
	string_t name
);
#endif

/* Routine dir_link */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_link
#if	defined(LINTLIBRARY)
    (dir, file, name, excl)
	file_t dir;
	file_t file;
	string_t name;
	int excl;
{ return dir_link(dir, file, name, excl); }
#else
(
	file_t dir,
	file_t file,
	string_t name,
	int excl
);
#endif

/* Routine dir_rename */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_rename
#if	defined(LINTLIBRARY)
    (olddirectory, oldname, newdirectory, newname, excl)
	file_t olddirectory;
	string_t oldname;
	file_t newdirectory;
	string_t newname;
	int excl;
{ return dir_rename(olddirectory, oldname, newdirectory, newname, excl); }
#else
(
	file_t olddirectory,
	string_t oldname,
	file_t newdirectory,
	string_t newname,
	int excl
);
#endif

/* Routine dir_mkfile */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_mkfile
#if	defined(LINTLIBRARY)
    (directory, flags, mode, newnode)
	file_t directory;
	int flags;
	mode_t mode;
	mach_port_t *newnode;
{ return dir_mkfile(directory, flags, mode, newnode); }
#else
(
	file_t directory,
	int flags,
	mode_t mode,
	mach_port_t *newnode
);
#endif

/* Routine dir_notice_changes */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t dir_notice_changes
#if	defined(LINTLIBRARY)
    (directory, port, portPoly)
	file_t directory;
	mach_port_t port;
	mach_msg_type_name_t portPoly;
{ return dir_notice_changes(directory, port, portPoly); }
#else
(
	file_t directory,
	mach_port_t port,
	mach_msg_type_name_t portPoly
);
#endif

/* Routine file_set_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_set_translator
#if	defined(LINTLIBRARY)
    (file, passive_flags, active_flags, oldtrans_flags, passive, passiveCnt, active, activePoly)
	file_t file;
	int passive_flags;
	int active_flags;
	int oldtrans_flags;
	data_t passive;
	mach_msg_type_number_t passiveCnt;
	mach_port_t active;
	mach_msg_type_name_t activePoly;
{ return file_set_translator(file, passive_flags, active_flags, oldtrans_flags, passive, passiveCnt, active, activePoly); }
#else
(
	file_t file,
	int passive_flags,
	int active_flags,
	int oldtrans_flags,
	data_t passive,
	mach_msg_type_number_t passiveCnt,
	mach_port_t active,
	mach_msg_type_name_t activePoly
);
#endif

/* Routine file_get_translator */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_get_translator
#if	defined(LINTLIBRARY)
    (file, translator, translatorCnt)
	file_t file;
	data_t *translator;
	mach_msg_type_number_t *translatorCnt;
{ return file_get_translator(file, translator, translatorCnt); }
#else
(
	file_t file,
	data_t *translator,
	mach_msg_type_number_t *translatorCnt
);
#endif

/* Routine file_get_translator_cntl */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_get_translator_cntl
#if	defined(LINTLIBRARY)
    (file, translator_cntl)
	file_t file;
	mach_port_t *translator_cntl;
{ return file_get_translator_cntl(file, translator_cntl); }
#else
(
	file_t file,
	mach_port_t *translator_cntl
);
#endif

/* Routine file_get_fs_options */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_get_fs_options
#if	defined(LINTLIBRARY)
    (file, options, optionsCnt)
	file_t file;
	data_t *options;
	mach_msg_type_number_t *optionsCnt;
{ return file_get_fs_options(file, options, optionsCnt); }
#else
(
	file_t file,
	data_t *options,
	mach_msg_type_number_t *optionsCnt
);
#endif

/* Routine file_reparent */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t file_reparent
#if	defined(LINTLIBRARY)
    (file, parent, new_file)
	file_t file;
	mach_port_t parent;
	mach_port_t *new_file;
{ return file_reparent(file, parent, new_file); }
#else
(
	file_t file,
	mach_port_t parent,
	mach_port_t *new_file
);
#endif

#endif	/* not defined(_fs_user_) */
