#ifndef	_auth_user_
#define	_auth_user_

/* Module auth */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine auth_getids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __auth_getids
#if	defined(LINTLIBRARY)
    (handle, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt)
	auth_t handle;
	idarray_t *euids;
	mach_msg_type_number_t *euidsCnt;
	idarray_t *auids;
	mach_msg_type_number_t *auidsCnt;
	idarray_t *egids;
	mach_msg_type_number_t *egidsCnt;
	idarray_t *agids;
	mach_msg_type_number_t *agidsCnt;
{ return __auth_getids(handle, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt); }
#else
(
	auth_t handle,
	idarray_t *euids,
	mach_msg_type_number_t *euidsCnt,
	idarray_t *auids,
	mach_msg_type_number_t *auidsCnt,
	idarray_t *egids,
	mach_msg_type_number_t *egidsCnt,
	idarray_t *agids,
	mach_msg_type_number_t *agidsCnt
);
#endif

/* Routine auth_makeauth */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __auth_makeauth
#if	defined(LINTLIBRARY)
    (handle, other_handles, other_handlesPoly, other_handlesCnt, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt, newhandle)
	auth_t handle;
	portarray_t other_handles;
	mach_msg_type_name_t other_handlesPoly;
	mach_msg_type_number_t other_handlesCnt;
	idarray_t euids;
	mach_msg_type_number_t euidsCnt;
	idarray_t auids;
	mach_msg_type_number_t auidsCnt;
	idarray_t egids;
	mach_msg_type_number_t egidsCnt;
	idarray_t agids;
	mach_msg_type_number_t agidsCnt;
	mach_port_t *newhandle;
{ return __auth_makeauth(handle, other_handles, other_handlesPoly, other_handlesCnt, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt, newhandle); }
#else
(
	auth_t handle,
	portarray_t other_handles,
	mach_msg_type_name_t other_handlesPoly,
	mach_msg_type_number_t other_handlesCnt,
	idarray_t euids,
	mach_msg_type_number_t euidsCnt,
	idarray_t auids,
	mach_msg_type_number_t auidsCnt,
	idarray_t egids,
	mach_msg_type_number_t egidsCnt,
	idarray_t agids,
	mach_msg_type_number_t agidsCnt,
	mach_port_t *newhandle
);
#endif

/* Routine auth_user_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __auth_user_authenticate
#if	defined(LINTLIBRARY)
    (handle, rendezvous, rendezvousPoly, newport)
	auth_t handle;
	mach_port_t rendezvous;
	mach_msg_type_name_t rendezvousPoly;
	mach_port_t *newport;
{ return __auth_user_authenticate(handle, rendezvous, rendezvousPoly, newport); }
#else
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_msg_type_name_t rendezvousPoly,
	mach_port_t *newport
);
#endif

/* Routine auth_server_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __auth_server_authenticate
#if	defined(LINTLIBRARY)
    (handle, rendezvous, rendezvousPoly, newport, newportPoly, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt)
	auth_t handle;
	mach_port_t rendezvous;
	mach_msg_type_name_t rendezvousPoly;
	mach_port_t newport;
	mach_msg_type_name_t newportPoly;
	idarray_t *euids;
	mach_msg_type_number_t *euidsCnt;
	idarray_t *auids;
	mach_msg_type_number_t *auidsCnt;
	idarray_t *egids;
	mach_msg_type_number_t *egidsCnt;
	idarray_t *agids;
	mach_msg_type_number_t *agidsCnt;
{ return __auth_server_authenticate(handle, rendezvous, rendezvousPoly, newport, newportPoly, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt); }
#else
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_msg_type_name_t rendezvousPoly,
	mach_port_t newport,
	mach_msg_type_name_t newportPoly,
	idarray_t *euids,
	mach_msg_type_number_t *euidsCnt,
	idarray_t *auids,
	mach_msg_type_number_t *auidsCnt,
	idarray_t *egids,
	mach_msg_type_number_t *egidsCnt,
	idarray_t *agids,
	mach_msg_type_number_t *agidsCnt
);
#endif


/* Module auth */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine auth_getids */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_getids
#if	defined(LINTLIBRARY)
    (handle, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt)
	auth_t handle;
	idarray_t *euids;
	mach_msg_type_number_t *euidsCnt;
	idarray_t *auids;
	mach_msg_type_number_t *auidsCnt;
	idarray_t *egids;
	mach_msg_type_number_t *egidsCnt;
	idarray_t *agids;
	mach_msg_type_number_t *agidsCnt;
{ return auth_getids(handle, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt); }
#else
(
	auth_t handle,
	idarray_t *euids,
	mach_msg_type_number_t *euidsCnt,
	idarray_t *auids,
	mach_msg_type_number_t *auidsCnt,
	idarray_t *egids,
	mach_msg_type_number_t *egidsCnt,
	idarray_t *agids,
	mach_msg_type_number_t *agidsCnt
);
#endif

/* Routine auth_makeauth */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_makeauth
#if	defined(LINTLIBRARY)
    (handle, other_handles, other_handlesPoly, other_handlesCnt, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt, newhandle)
	auth_t handle;
	portarray_t other_handles;
	mach_msg_type_name_t other_handlesPoly;
	mach_msg_type_number_t other_handlesCnt;
	idarray_t euids;
	mach_msg_type_number_t euidsCnt;
	idarray_t auids;
	mach_msg_type_number_t auidsCnt;
	idarray_t egids;
	mach_msg_type_number_t egidsCnt;
	idarray_t agids;
	mach_msg_type_number_t agidsCnt;
	mach_port_t *newhandle;
{ return auth_makeauth(handle, other_handles, other_handlesPoly, other_handlesCnt, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt, newhandle); }
#else
(
	auth_t handle,
	portarray_t other_handles,
	mach_msg_type_name_t other_handlesPoly,
	mach_msg_type_number_t other_handlesCnt,
	idarray_t euids,
	mach_msg_type_number_t euidsCnt,
	idarray_t auids,
	mach_msg_type_number_t auidsCnt,
	idarray_t egids,
	mach_msg_type_number_t egidsCnt,
	idarray_t agids,
	mach_msg_type_number_t agidsCnt,
	mach_port_t *newhandle
);
#endif

/* Routine auth_user_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_user_authenticate
#if	defined(LINTLIBRARY)
    (handle, rendezvous, rendezvousPoly, newport)
	auth_t handle;
	mach_port_t rendezvous;
	mach_msg_type_name_t rendezvousPoly;
	mach_port_t *newport;
{ return auth_user_authenticate(handle, rendezvous, rendezvousPoly, newport); }
#else
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_msg_type_name_t rendezvousPoly,
	mach_port_t *newport
);
#endif

/* Routine auth_server_authenticate */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t auth_server_authenticate
#if	defined(LINTLIBRARY)
    (handle, rendezvous, rendezvousPoly, newport, newportPoly, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt)
	auth_t handle;
	mach_port_t rendezvous;
	mach_msg_type_name_t rendezvousPoly;
	mach_port_t newport;
	mach_msg_type_name_t newportPoly;
	idarray_t *euids;
	mach_msg_type_number_t *euidsCnt;
	idarray_t *auids;
	mach_msg_type_number_t *auidsCnt;
	idarray_t *egids;
	mach_msg_type_number_t *egidsCnt;
	idarray_t *agids;
	mach_msg_type_number_t *agidsCnt;
{ return auth_server_authenticate(handle, rendezvous, rendezvousPoly, newport, newportPoly, euids, euidsCnt, auids, auidsCnt, egids, egidsCnt, agids, agidsCnt); }
#else
(
	auth_t handle,
	mach_port_t rendezvous,
	mach_msg_type_name_t rendezvousPoly,
	mach_port_t newport,
	mach_msg_type_name_t newportPoly,
	idarray_t *euids,
	mach_msg_type_number_t *euidsCnt,
	idarray_t *auids,
	mach_msg_type_number_t *auidsCnt,
	idarray_t *egids,
	mach_msg_type_number_t *egidsCnt,
	idarray_t *agids,
	mach_msg_type_number_t *agidsCnt
);
#endif

#endif	/* not defined(_auth_user_) */
