/* glppfi/pfi_btran.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glppfi.h"

/*----------------------------------------------------------------------
-- pfi_btran - perform backward transformation (BTRAN) using PFI.
--
-- *Synopsis*
--
-- #include "glppfi.h"
-- double *pfi_btran(PFI *pfi, double z[]);
--
-- *Description*
--
-- The pfi_btran routine performs backward transformation of the vector
-- z using PFI which pfi points to.
--
-- In order to perform this operation the routine solves the system
-- B'*x = z, where B' is a matrix transposed to the basis matrix B that
-- is defined by PFI, x is vector of unknowns (transformed vector that
-- should be computed), z is vector of right-hand sides (given vector
-- that should be transformed). On entry the array z should contain
-- elements of the vector z in locations z[1], z[2], ..., z[m], where
-- m is the order of the matrix B. On exit this array will contain the
-- vector x in the same locations.
--
-- *Returns*
--
-- The pfi_btran routine returns a pointer to the array z. */

double *pfi_btran(PFI *pfi, double z[])
{     ht_solve(pfi->eta, z);
      solve_lu(pfi->lu, 1, z, pfi->work);
      return z;
}

/* eof */
