/* glpmat/check_mplets.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpmat.h"

/*----------------------------------------------------------------------
-- check_mplets - check whether sparse matrix has multiplets.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- ELEM *check_mplets(MAT *A);
--
-- *Description*
--
-- The check_mplets routine checks whether the sparse matrix A has any
-- multiplets, i.e. sets of elements which have identical row and column
-- indices.
--
-- *Returns*
--
-- If the matrix A has no multiplets, the check_mplets routine returns
-- NULL. Otherwise the routine returns a pointer to some element which
-- belongs to some multiplet. */

ELEM *check_mplets(MAT *A)
{     int i;
      sort_mat(A);
      for (i = 1; i <= A->m; i++)
      {  ELEM *e;
         for (e = A->row[i]; e != NULL; e = e->row)
            if (e->row != NULL && e->j == e->row->j) return e;
      }
      return NULL;
}

/* eof */
