/* glprsm/invert_b.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glprsm.h"

/*----------------------------------------------------------------------
-- invert_b - rebuild representation of basis matrix.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- int invert_b(RSM *rsm);
--
-- *Description*
--
-- The invert_b routine reinverts the basis matrix B, i.e. it rebuilds
-- anew some representation of the basis matrix.
--
-- This operation can be used in the following cases:
--
-- a) if it is necessary to rebuild the representation for some initial
--    basis matrix;
--
-- b) if the representation of the current basis matrix has become too
--    large or inaccurate;
--
-- c) if the basis matrix has been completely changed.
--
-- The invert_b routine assumes that the array rsm.indb specifies what
-- columns of the expanded matrix A belong to the basis matrix B.
--
-- *Returns*
--
-- If the operation was successful, the invert_b routine returns zero.
-- Otherwise the routine returns non-zero. The latter case means that
-- the basis matrix is numerically singular or ill-conditioned (for
-- futher information see descriptions of particular routines that
-- perform this operation). */

int invert_b(RSM *rsm)
{     int ret;
      if (rsm->pfi != NULL)
         ret = build_pfi(rsm->pfi, rsm->A, rsm->indb);
      else if (rsm->rfi != NULL)
         ret = build_rfi(rsm->rfi, rsm->A, rsm->indb);
      else if (rsm->afi != NULL)
         ret = build_afi(rsm->afi, rsm->A, rsm->indb);
      else if (rsm->ufi != NULL)
         ret = build_ufi(rsm->ufi, rsm->A, rsm->indb);
      else
         insist(rsm != rsm);
      return ret;
}

/* eof */
