/* glpgel/monit_lu.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <time.h>
#include "glpgel.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- monit_lu - standard monitoring routine.
--
-- *Synopsis*
--
-- #include "glpgel.h"
-- void monit_lu(LU *lu, int kase, int i, int k, double f);
--
-- *Description*
--
-- The monit_lu routine is standard monitoring routine, that may be
-- passed to the build_lu routine. For more details see description of
-- the build_lu routine. */

void monit_lu(LU *lu, int kase, int i, int k, double f)
{     static clock_t t = 0;
      insist(i == i && f == f);
      switch (kase)
      {  case 0:
            t = clock();
            break;
         case 1:
            if (lu->L->pool->count % 1000 == 0)
            {  if (t + CLOCKS_PER_SEC < clock())
               {  print("monit_lu: n = %d; k = %d (%d%%); nz(L) = %d; n"
                     "z(U) = %d", lu->n, k,
                     (int)(((double)k / (double)lu->n) * 100.0 + 0.5),
                     lu->L->pool->count, lu->U->pool->count);
                  t = clock();
               }
            }
            break;
         case 2:
            t = 0;
            break;
      }
      return;
}

/* eof */
