/* glpchol/decomp_chol.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpchol.h"

/*----------------------------------------------------------------------
-- decomp_chol - compute Cholesky factorization.
--
-- *Synopsis*
--
-- #include "glpchol.h"
-- void decomp_chol(CHOL *chol, MAT *A);
--
-- *Description*
--
-- The decomp_chol routine performs numeric phase of Cholesky
-- factorization for the given symmetric positive definite matrix A.
-- The matrix A passed to the decomp_chol routine should have exactly
-- the same pattern as the matrix passed to the create_chol routine.
--
-- For details see comments to the chol_numb routine. */

void decomp_chol(CHOL *chol, MAT *A)
{     /* compute permuted matrix A~ = P*A*P' */
      per_sym(chol->P, A, NULL);
      /* compute numeric Cholesky factorization A~ = U'*U */
      chol->sing = chol_numb(A, chol->U, NULL, NULL);
      /* restore original matrix A = P'*A~*P */
      inv_per(chol->P);
      per_sym(chol->P, A, NULL);
      inv_per(chol->P);
      return;
}

/* eof */
