/* glpmip.h */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#ifndef _GLPMIP_H
#define _GLPMIP_H

#include "glpprob.h"

#define mip1_driver           glp_mip1_driver

struct mip1_cp
{     /* control parameters passed to the mip1_driver routine */
      int what;
      /* this parameter specifies what basis solution should be found
         by the solver:
         0 - initial relaxed solution
         1 - feasible integer solution
         2 - optimal integer solution */
      int branch;
      /* this parameter specifies what branching technique should be
         used by the solver:
         0 - branch on the first integer variable
         1 - branch on the last integer variable
         2 - branch using heuristic by Driebeek and Tomlin */
      int btrack;
      /* this parameter specifies what backtracking technique should be
         used by the solver:
         0 - backtrack using FIFO strategy
         1 - backtrack using LIFO strategy
         2 - backtrack using the best projection heuristic */
      double tol_int;
      /* absolute tolerance which is used to see if the solution is
         integer feasible */
      double tol_obj;
      /* relative tolerance which is used to check if current value of
         the objective function is not better than for the best integer
         feasible solution found */
      int form;
      /* this parameter specifies what form of the basis matrix should
         be used by the solver:
         0 - EFI
         1 - RFI + Bartels & Golub updating technique
         2 - RFI + Forrest & Tomlin updating technique */
      int steep;
      /* if this flag is set, the solver uses the steepest edge pricing
         proposed by Goldfarb & Reid; otherwise the standard "textbook"
         pricing is used */
      int relax;
      /* if this flag is set, the solver uses two-pass ratio test
         proposed by P.Harris; otherwise the standard "textbook" ratio
         test is used */
      double tol_bnd;
      /* relative tolerance which is used to see if the solution is
         primal feasible */
      double tol_dj;
      /* relative tolerance which is used to see if the solution is
         dual feasible */
      double tol_piv;
      /* relative tolerance which is used to choose the pivot element
         of the simplex table */
      int iter_max;
      /* maximal allowed number of iterations (0 means no limit) */
      int round;
      /* if this flag is set, the solver replaces computed values of
         basic continuous variables which are close to zero by exact
         zeros; otherwise all computed values are remained "as is" */
};

extern int mip1_driver(LP *lp, LPSOL *sol, struct mip1_cp *cp);
/* driver for the branch-and-bound procedure */

#endif

/* eof */
