/* glpmat/per_vec.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpmat.h"

/*----------------------------------------------------------------------
-- per_vec - permute vector elements (y := P * x).
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- double *per_vec(double y[], PER *P, double x[]);
--
-- *Description*
--
-- The per_vec routine computes the product y := P * x, where P is a
-- permutation matrix, x and y are dense vectors. The matrix P and the
-- vector x remain unchanged. The input array x should contain vector
-- elements in x[1], x[2], ..., x[n], where n is the order of the matrix
-- P. The output array y will contain vector elements in the same array
-- locations. The arrays x and y should not overlap each other.
--
-- *Returns*
--
-- The per_vec routine returns a pointer to the array y. */

double *per_vec(double y[], PER *P, double x[])
{     int i;
      for (i = 1; i <= P->n; i++) y[i] = x[P->row[i]];
      return y;
}

/* eof */
