/* glprsm/rsm_set_bp.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glprsm.h"

/*----------------------------------------------------------------------
-- rsm_set_bp - compute p-th row of the inverse inv(B).
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- void rsm_set_bp(RSM *rsm);
--
-- *Description*
--
-- The rsm_set_bp routine computes the p-th row of the inverse inv(B)
-- using the following formula:
--
--    bp = inv(B') * e[p],
--
-- where bp is the p-th row of inv(B), B' is a matrix transposed to the
-- current basis matrix B, e[p] is unity vector containing 1 in the p-th
-- position. */

void rsm_set_bp(RSM *rsm)
{     int m = rsm->m, p = rsm->p, i;
      insist(1 <= p && p <= m);
      for (i = 1; i <= m; i++) rsm->bp[i] = 0.0;
      rsm->bp[p] = 1.0;
      rsm_btran(rsm, rsm->bp);
      return;
}

/* eof */
