/* glpgel.h */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#ifndef _GLPGEL_H
#define _GLPGEL_H

#include "glpduff.h"
#include "glpmat.h"

#define gel                   glp_gel
#define gel_bg                glp_gel_bg
#define gel_ft                glp_gel_ft
#define min_bump              glp_min_bump
#define create_lu             glp_create_lu
#define build_lu              glp_build_lu
#define monit_lu              glp_monit_lu
#define solve_lu              glp_solve_lu
#define delete_lu             glp_delete_lu

extern int gel(MAT *V, PER *P, PER *Q,
      void (*func)(int i, int k, double f), double tol, double lim,
      int *Unz, double *Umax, double *Ubig, DUFF *rs, DUFF *cs,
      double rmax[], double work[]);
/* sparse gaussian elimination */

extern int gel_bg(PER *P, MAT *V, PER *Q, int k1, int k2,
      void (*func)(int i, int k, double f), double tol, double eps,
      int *Unz, double work[]);
/* sparse gaussian elimination (Bartels & Golub technique) */

extern int gel_ft(PER *P, MAT *V, PER *Q, int k1, int k2,
      void (*func)(int i, int k, double f), double eps, int *Unz,
      double work[]);
/* sparse gaussian elimination (Forrest & Tomlin technique) */

void min_bump(PER *P, MAT *V, PER *Q, int *k1, int *k2,
      DUFF *rs, DUFF *cs, int prev[], int next[]);
/* minimize bump size of given matrix (Reid's technique) */

typedef struct LU LU;

struct LU
{     /* LU-factorization in the form A = P*L*U*Q */
      int n;
      /* order of matrices */
      PER *P;
      /* left permutation matrix */
      MAT *L;
      /* lower triangular matrix with unit main diagonal */
      MAT *U;
      /* upper triangular matrix */
      PER *Q;
      /* right permutation matrix */
};

extern LU *create_lu(int n);
/* create LU-factorization */

extern int build_lu(LU *lu, MAT *A, double tol, double lim,
      void (*monit)(LU *lu, int kase, int i, int k, double f),
      double *Amax, double *Ubig);
/* compute LU-factorization of given matrix */

extern void monit_lu(LU *lu, int kase, int i, int k, double f);
/* standard monitoring routine */

extern void solve_lu(LU *lu, int flag, double x[], double work[]);
/* solve linear system using LU-factorization */

extern void delete_lu(LU *lu);
/* delete LU-factorization */

#endif

/* eof */
