/* glpstr/create_str.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpstr.h"

/*----------------------------------------------------------------------
-- create_str - create segmented character string.
--
-- *Synopsis*
--
-- #include "glpstr.h"
-- STR *create_str(POOL *pool);
--
-- *Description*
--
-- The create_str routine creates empty segmented character string.
--
-- The parameter pool specifies the memory pool created by the
-- create_str_pool routine. The create_str routine connects this pool
-- with the string, so it will be used in all subsequent operations on
-- this string.
--
-- Should note that the same pool may be shared by different strings.
--
-- *Returns*
--
-- The create_str routine returns a pointer to the created string. */

STR *create_str(POOL *pool)
{     STR *str;
      str = get_atom(pool);
      str->pool = pool;
      str->len = 0;
      str->head = str->tail = NULL;
      return str;
}

/* eof */
