/* glpset/umalloc.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include "glpset.h"

int mem_flag = 0x20101960;
int mem_limit = INT_MAX;
int mem_total = 0;
int mem_tpeak = 0;
int mem_count = 0;
int mem_cpeak = 0;

/*----------------------------------------------------------------------
-- umalloc - allocate memory block.
--
-- *Synopsis*
--
-- #include "glpset.h"
-- void *umalloc(int size);
--
-- *Description*
--
-- The umalloc routine allocates a memory block of size bytes long and
-- clears the allocated block by binary zeros. If the operation fails,
-- abnormal program termination occurs.
--
-- *Returns*
--
-- The umalloc routine returns a pointer to the allocated memory block.
-- To free this block the ufree (not free!) routine should be used. */

void *umalloc(int size)
{     struct mem_desc *desc;
      if (size < 1)
         fault("umalloc: invalid size");
      if (size > INT_MAX - sizeof(struct mem_desc))
         fault("umalloc: size too big");
      size += sizeof(struct mem_desc);
      if (size > mem_limit - mem_total)
         fault("umalloc: no memory available");
      desc = malloc(size);
      if (desc == NULL)
         fault("umalloc: malloc failed");
      memset(desc, 0, size);
      desc->size = size;
      desc->flag = mem_flag;
      mem_total += size;
      if (mem_tpeak < mem_total) mem_tpeak = mem_total;
      mem_count++;
      if (mem_cpeak < mem_count) mem_cpeak = mem_count;
      return (void *)((char *)desc + sizeof(struct mem_desc));
}

/* eof */
