/* glprsm/rsm_set_pi.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glprsm.h"

/*----------------------------------------------------------------------
-- rsm_set_pi - compute simplex multipliers.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- void rsm_set_pi(RSM *rsm);
--
-- *Description*
--
-- The rsm_set_pi routine computes simplex multipliers for all equality
-- constraints and stores them to the array pi. The routine assumes that
-- objective function coefficients were stored before to the array cbar.
--
-- The routine uses the following formula:
--
--    pi = inv(B') * cB,
--
-- where pi is the vector of simplex multipliers, B' is a matrix
-- transposed to the current basis matrix B, cB is the vector containing
-- objective function coefficients at the basis variables. */

void rsm_set_pi(RSM *rsm)
{     int m = rsm->m, i, k;
      double *cB = rsm->pi;
      /* pi = inv(BT) * cB */
      for (i = 1; i <= m; i++)
      {  k = rsm->indb[i]; /* x[k] = xB[i] */
         cB[i] = rsm->cost[k];
      }
      rsm_btran(rsm, rsm->pi);
      return;
}

/* eof */
