/* glprsm/rsm_infsum.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glprsm.h"

/*----------------------------------------------------------------------
-- rsm_infsum - compute sum of infeasibilities.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- double rsm_infsum(RSM *rsm);
--
-- *Returns*
--
-- The routine returns the sum of infeasibilities for the current basis
-- solution. Should note that this sum is scaled, so it may be used only
-- for visual estimating. */

double rsm_infsum(RSM *rsm)
{     int m = rsm->m, i, k;
      double sum = 0.0;
      for (i = 1; i <= m; i++)
      {  k = rsm->indb[i]; /* x[k] = xB[i] */
         if (rsm->type[k] == LP_LO ||
             rsm->type[k] == LP_DB ||
             rsm->type[k] == LP_FX)
            if (rsm->bbar[i] < rsm->lb[k])
               sum += (rsm->lb[k] - rsm->bbar[i]);
         if (rsm->type[k] == LP_UP ||
             rsm->type[k] == LP_DB ||
             rsm->type[k] == LP_FX)
            if (rsm->bbar[i] > rsm->ub[k])
               sum += (rsm->bbar[i] - rsm->ub[k]);
      }
      return sum;
}

/* eof */
