/* glprsm/rsm_get_xn.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <assert.h>
#include "glprsm.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- rsm_get_xn - get current value of non-basis variable.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- double rsm_get_xn(RSM *rsm, int j);
--
-- *Returns*
--
-- The rsm_get_xn routine returns the current value of the non-basis
-- variable xN[j] (1 <= j <= n). */

double rsm_get_xn(RSM *rsm, int j)
{     int n = rsm->n, k;
      double t;
      assert(1 <= j && j <= n);
      k = rsm->indn[j]; /* x[k] = xN[j] */
      switch (rsm->tagn[j])
      {  case LP_NL:
            t = rsm->lb[k]; break;
         case LP_NU:
            t = rsm->ub[k]; break;
         case LP_NF:
            t = 0.0; break;
         case LP_NS:
            t = rsm->lb[k]; break;
         default:
            assert(rsm->tagn[j] != rsm->tagn[j]);
      }
      return t;
}

/* eof */
