/* glprfi/create_rfi.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glprfi.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- create_rfi - create RFI.
--
-- *Synopsis*
--
-- #include "glprfi.h"
-- RFI *create_rfi(int m);
--
-- *Description*
--
-- The create_rfi routine creates RFI for the basis matrix of order m.
-- Initially the created RFI corresponds to the unity matrix.
--
-- *Returns*
--
-- The create_rfi routine returns a pointer to the created RFI. */

RFI *create_rfi(int m)
{     RFI *rfi;
      int k;
      if (m < 1)
         fault("create_rfi: invalid order");
      rfi = umalloc(sizeof(RFI));
      rfi->m = m;
      /* H := I */
      rfi->H = create_eta(m);
      /* V := I */
      rfi->V = create_mat(m, m);
      for (k = 1; k <= m; k++) new_elem(rfi->V, k, k, 1.0);
      /* P := Q := I */
      rfi->P = create_per(m);
      rfi->Q = create_per(m);
      /* initialize counts */
      rfi->nzH0 = 0;
      rfi->nzV0 = m;
      /* use Reid's technique by default */
      rfi->reid = 1;
      /* use Bartels & Golub technique by default */
      rfi->tech = RFI_BG;
      /* allocate memory for transformed column */
      rfi->col = ucalloc(1+m, sizeof(double));
      /* column is not prepared yet */
      rfi->flag = 0;
      /* create auxiliary Duff's schemes */
      rfi->rs = create_duff(m, m);
      rfi->cs = create_duff(m, m);
      /* allocate memory for working array */
      rfi->work = ucalloc(1+m, sizeof(double));
      /* return to the calling program */
      return rfi;
}

/* eof */
