/* glpmat/trn_mat.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpmat.h"

/*----------------------------------------------------------------------
-- trn_mat - transpose sparse matrix.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- MAT *trn_mat(MAT *A);
--
-- *Description*
--
-- The trn_mat routine transposes the matrix A.
--
-- *Returns*
--
-- The trn_mat routine returns a pointer to the matrix A. */

MAT *trn_mat(MAT *A)
{     ELEM **ptr, *e, *x;
      int i, t;
      t = A->m, A->m = A->n, A->n = t;
      ptr = A->row, A->row = A->col, A->col = ptr;
      for (i = 1; i <= A->m; i++)
      {  for (e = A->row[i]; e != NULL; e = e->row)
         {  t = e->i, e->i = e->j, e->j = t;
            x = e->row, e->row = e->col, e->col = x;
         }
      }
      return A;
}

/* eof */
