/* glpmat/test_mat_e.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpmat.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- test_mat_e - create test sparse matrix of E(n,c) class.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- MAT *test_mat_e(int n, int c);
--
-- *Description*
--
-- The test_mat_e routine creates a test sparse matrix of E(n,c) class
-- as described in the book: Ole 0sterby, Zahari Zlatev. Direct Methods
-- for Sparse Matrices. Springer-Verlag, 1983.
--
-- Matrix of E(n,c) class is a symmetric positive definite matrix of
-- order n. It has the number 4 on its main diagonal and the number -1
-- on its four codiagonals, two of which neighbour with main diagonal
-- and two others are away from main diagonal in the distance of c.
--
-- It is necessary that n >= 3 and 2 <= c <= n-1.
--
-- *Returns*
--
-- The test_mat_e routine returns a pointer to the created matrix. */

MAT *test_mat_e(int n, int c)
{     MAT *A;
      int i;
      if (!(n >= 3 && 2 <= c && c <= n-1))
         fault("test_mat_e: invalid parameters");
      A = create_mat(n, n);
      for (i = 1; i <= n; i++)
         new_elem(A, i, i, 4.0);
      for (i = 1; i <= n-1; i++)
      {  new_elem(A, i, i+1, -1.0);
         new_elem(A, i+1, i, -1.0);
      }
      for (i = 1; i <= n-c; i++)
      {  new_elem(A, i, i+c, -1.0);
         new_elem(A, i+c, i, -1.0);
      }
      return A;
}

/* eof */
