/* glpmat/test_mat_d.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include "glpmat.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- test_mat_d - create test sparse matrix of D(n,c) class.
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- MAT *test_mat_d(int n, int c);
--
-- *Description*
--
-- The test_mat_d routine creates a test sparse matrix of D(n,c) class
-- as described in the book: Ole 0sterby, Zahari Zlatev. Direct Methods
-- for Sparse Matrices. Springer-Verlag, 1983.
--
-- Matrix of D(n,c) class is a quadratic matrix of order n. It has unit
-- diagonal, three codiagonals above main diagonal in the distance of c,
-- which are cyclically continued below main diagonal, and a triangle of
-- 10x10 elements in the upper right corner.
--
-- It is necessary that n >= 14 and 1 <= c <= n-13.
--
-- *Returns*
--
-- The test_mat_d routine returns a pointer to the created matrix. */

MAT *test_mat_d(int n, int c)
{     MAT *A;
      int i, j;
      if (!(n >= 14 && 1 <= c && c <= n-13))
         fault("test_mat_d: invalid parameters");
      A = create_mat(n, n);
      for (i = 1; i <= n; i++)
         new_elem(A, i, i, 1.0);
      for (i = 1; i <= n-c; i++)
         new_elem(A, i, i+c, (double)(i+1));
      for (i = n-c+1; i <= n; i++)
         new_elem(A, i, i-n+c, (double)(i+1));
      for (i = 1; i <= n-c-1; i++)
         new_elem(A, i, i+c+1, (double)(-i));
      for (i = n-c; i <= n; i++)
         new_elem(A, i, i-n+c+1, (double)(-i));
      for (i = 1; i <= n-c-2; i++)
         new_elem(A, i, i+c+2, 16.0);
      for (i = n-c-1; i <= n; i++)
         new_elem(A, i, i-n+c+2, 16.0);
      for (j = 1; j <= 10; j++)
      {  for (i = 1; i <= 11-j; i++)
            new_elem(A, i, n-11+i+j, 100.0*(double)j);
      }
      return A;
}

/* eof */
