/* glpmat/per_mat.c */

/*----------------------------------------------------------------------
-- This file is a part of the GNU LPK package.
--
-- Copyright (C) 2000 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                    Department for Applied Informatics,
--                    Moscow Aviation Institute, Moscow, Russia.
--                    All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glpmat.h"
#include "glpset.h"

/*----------------------------------------------------------------------
-- per_mat - permute matrix rows (A := P * A).
--
-- *Synopsis*
--
-- #include "glpmat.h"
-- MAT *per_mat(PER *P, MAT *A, void *work[]);
--
-- *Description*
--
-- The per_mat routine computes the product A := P * A, where P is a
-- permutation matrix, A is a sparse matrix of general kind. The matrix
-- P remains unchanged. The auxiliary array work should have at least
-- 1+m elements, where m is the number of rows of the matrix A.
--
-- *Returns*
--
-- The per_mat returns a pointer to the matrix A. */

MAT *per_mat(PER *P, MAT *A, void *work[])
{     int i;
      if (P->n != A->m)
         fault("per_mat: product undefined");
      for (i = 1; i <= A->m; i++) work[i] = A->row[i];
      for (i = 1; i <= A->m; i++)
      {  ELEM *e;
         A->row[i] = work[P->row[i]];
         for (e = A->row[i]; e != NULL; e = e->row) e->i = i;
      }
      return A;
}

/* eof */
